---@type ZoneDB
local ZoneDB = QuestieLoader:ImportModule("ZoneDB")
---@class ZoneDBPrivate
ZoneDB.private = {}

--- This table maps the areaId (used in the DB for example) to
--- the UiMapId of each zone.
--- The UiMapId identifies a map which can be displayed ingame on the worldmap.
--- Dungeons don't have a UiMapId!
--- https://wow.gamepedia.com/UiMapID/Classic
---@type table<AreaId, UiMapId>
ZoneDB.private.areaIdToUiMapId = {
    [1] = 1426, -- Dun Morogh
    [3] = 1418, -- Badlands
    [4] = 1419, -- Blasted Lands
    [8] = 1435, -- Swamp of Sorrows
    [10] = 1431, -- Duskwood
    [11] = 1437, -- Wetlands
    [12] = 1429, -- Elwynn Forest
    [14] = 1411, -- Durotar
    [15] = 1445, -- Dustwallow Marsh
    [16] = 1447, -- Azshara
    [17] = 1413, -- The Barrens
    [28] = 1422, -- Western Plaguelands
    [33] = 1434, -- Stranglethorn Vale
    [36] = 1416, -- Alterac Mountains
    [38] = 1432, -- Loch Modan
    [40] = 1436, -- Westfall
    [41] = 1430, -- Deadwind Pass
    [44] = 1433, -- Redridge Mountains
    [45] = 1417, -- Arathi Highlands
    [46] = 1428, -- Burning Steppes
    [47] = 1425, -- The Hinterlands
    [51] = 1427, -- Searing Gorge
    [65] = 115, -- Dragonblight
    [66] = 121, -- Zul'Drak
    [67] = 120, -- The Storm Peaks
    [85] = 1420, -- Tirisfal Glades
    [130] = 1421, -- Silverpine Forest
    [139] = 1423, -- Eastern Plaguelands
    [141] = 1438, -- Teldrassil
    [148] = 1439, -- Darkshore
    [209] = 310, -- Shadowfang Keep - Dungeon
    [210] = 118, -- Icecrown
    [215] = 1412, -- Mulgore
    [267] = 1424, -- Hillsbrad Foothills
    [331] = 1440, -- Ashenvale
    [357] = 1444, -- Feralas
    [361] = 1448, -- Felwood
    [394] = 116, -- Grizzly Hills
    [400] = 1441, -- Thousand Needles
    [405] = 1443, -- Desolace
    [406] = 1442, -- Stonetalon Mountains
    [440] = 1446, -- Tanaris
    [490] = 1449, -- Un'Goro Crater
    [491] = 301, -- Razorfen Kraul - Dungeon
    [493] = 1450, -- Moonglade
    [495] = 117, -- Howling Fjord
    [618] = 1452, -- Winterspring
    [717] = 225, -- The Stockade - Dungeon
    [718] = 279, -- Wailing Caverns - Dungeon
    [719] = 221, -- Blackfathom Deeps - Dungeon
    [721] = 226, -- Gnomeregan - Dungeon
    [722] = 300, -- Razorfen Downs - Dungeon
    [796] = 302, -- Scarlet Monastery - Dungeon
    [1176] = 219, -- Zul'Farrak - Dungeon
    [1337] = 230, -- Uldaman - Dungeon
    [1377] = 1451, -- Silithus
    [1477] = 220, -- The Temple of Atal'Hakkar - Dungeon
    [1497] = 1458, -- Undercity
    [1519] = 1453, -- Stormwind City
    [1537] = 1455, -- Ironforge
    [1581] = 291, -- The Deadmines - Dungeon
    [1583] = 250, -- Blackrock Spire - Dungeon
    [1584] = 242, -- Blackrock Depths - Dungeon
    [1637] = 1454, -- Orgrimmar
    [1638] = 1456, -- Thunder Bluff
    [1657] = 1457, -- Darnassus
    [1977] = 233, -- Zul'Gurub - Raid
    [2017] = 317, -- Stratholme - Dungeon
    [2100] = 280, -- Maraudon - Dungeon
    [2159] = 248, -- Onyxia's Lair - Dungeon?
    [2366] = 273, -- The Black Morass - Dungeon
    [2367] = 274, -- Old Hillsbrad Foothills - Dungeon
    [2437] = 213, -- Ragefire Chasm - Dungeon
    [2557] = 234, -- Dire Maul - Dungeon
    [2597] = 1459, -- Alterac Valley - Battleground
    [2677] = 287, -- Blackwing Lair - Raid
    [2717] = 232, -- Molten Core - Raid
    [2817] = 127, -- Crystalsong Forest
    [3277] = 1460, -- Warsong Gulch - Battleground
    [3358] = 1461, -- Arathi Basin - Battleground
    [3428] = 319, -- Ahn'Qiraj - Raid
    [3429] = 247, -- Ruins of Ahn'Qiraj - Raid
    [3430] = 1941, -- Eversong Woods
    [3433] = 1942, -- Ghostlands
    [3456] = 162, -- Naxxramas - Raid
    [3457] = 350, -- Karazhan - Raid
    [3483] = 1944, -- Hellfire Peninsula
    [3487] = 1954, -- Silvermoon City
    [3518] = 1951, -- Nagrand
    [3519] = 1952, -- Terokkar Forest
    [3520] = 1948, -- Shadowmoon Valley
    [3521] = 1946, -- Zangarmarsh
    [3522] = 1949, -- Blade's Edge Mountains
    [3523] = 1953, -- Netherstorm
    [3524] = 1943, -- Azuremyst Isle
    [3525] = 1950, -- Bloodmyst Isle
    [3535] = 246, -- Hellfire Citadel - Dungeon This is hellfire citadel area in The Shattered halls, have to have it because mobs use this AreaId
    [3537] = 114, -- Borean Tundra
    [3557] = 1947, -- The Exodar
    [3562] = 347, -- Hellfire Ramparts - Dungeon
    [3606] = 329, -- Hyjal Summit - Raid
    [3607] = 332, -- Serpentshrine Cavern - Raid
    [3703] = 1955, -- Shattrath City
    [3711] = 119, -- Sholazar Basin
    [3713] = 261, -- The Blood Furnace - Dungeon
    [3714] = 246, -- The Shattered Halls - Dungeon
    [3715] = 263, -- The Steamvault - Dungeon
    [3716] = 262, -- The Underbog - Dungeon
    [3717] = 265, -- The Slave Pens - Dungeon
    [3789] = 260, -- Shadow Labyrinth - Dungeon
    [3790] = 256, -- Auchenai Crypts - Dungeon
    [3791] = 258, -- Sethekk Halls - Dungeon
    [3792] = 272, -- Mana-Tombs - Dungeon
    [3805] = 333, -- Zul'Aman - Raid
    [3820] = 1956, -- Eye of the Storm - Battleground
    [3836] = 331, -- Magtheridon's Lair - Raid
    [3845] = 334, -- Tempest Keep - Raid
    [3847] = 266, -- The Botanica - Dungeon
    [3848] = 269, -- The Arcatraz - Dungeon
    [3849] = 267, -- The Mechanar - Dungeon
    [3923] = 330, -- Gruul's Lair - Raid
    [3959] = 339, -- Black Temple - Raid
    [4075] = 335, -- Sunwell Plateau - Raid
    [4080] = 1957, -- Isle of Quel'Danas
    [4811] = 130, -- The Culling of Stratholme - Village (fake ID for The Culling of Stratholme)
    [4814] = 131, -- The Culling of Stratholme - City (fake ID for The Culling of Stratholme)
    [4822] = 160, -- Drak'Tharon Keep - Lower Level (fake ID for Drak'Tharon Keep)
    [4823] = 161, -- Drak'Tharon Keep - Upper Level (fake ID for Drak'Tharon Keep)
    [4824] = 154, -- Gundrak - Upper Level (fake ID for Gundrak)
    [4825] = 153, -- Gundrak - Lower Level (fake ID for Gundrak)
    [4197] = 123, -- Wintergrasp
    [4228] = 142, -- The Oculus - Dungeon
    [4810] = 140, -- Halls of Stone - dungeon map (fake ID for Halls of Stone)
    [4805] = 129, -- The Nexus - dungeon map (fake ID for The Nexus)
    [4272] = 138, -- Halls of Lightning - Dungeon
    [4273] = 147, -- Ulduar - Raid
    [4274] = 139, -- Halls of Lightning - The Terrestrial Watchtower (fake ID for Halls of Lightning)
    [4301] = 157, -- Azjol-Nerub - The Brood Pit (fake ID for Azjol-Nerub)
    [4298] = 124, -- Plaguelands: The Scarlet Enclave
    [4384] = 128, -- Strand of the Ancients - Battleground
    [4395] = 125, -- Dalaran - Dungeon?
    [4415] = 168, -- The Violet Hold - Dungeon
    [4493] = 155, -- The Obsidian Sanctum - Raid
    [4808] = 132, -- Ahn'kahet: The Old Kingdom - dungeon map (fake ID for Ahn'kahet: The Old Kingdom)
    [4500] = 141, -- The Eye of Eternity - Raid
    [4560] = 126, -- The Underbelly - Sub zone of Dalaran
    [4603] = 156, -- Vault of Archavon - Raid
    [4657] = 148, -- Ulduar - The Antechamber of Ulduar
    [4659] = 150, -- Ulduar - The Descent of Madness (fake ID for Ulduar)
    [4660] = 151, -- Ulduar - The Spark of Imagination (fake ID for Ulduar)
    [4661] = 149, -- Ulduar - The Inner Sanctum of Ulduar (fake ID for Ulduar)
    [4710] = 169, -- Isle of Conquest - Battleground
    [4722] = 172, -- Trial of the Crusader - Raid
    [4723] = 171, -- Trial of the Champion - Dungeon
    [4742] = 170, -- Hrothgar's Landing
    [4801] = 143, -- The Oculus - Band of Variance (fake ID for The Oculus)
    [4802] = 144, -- The Oculus - Band of Acceleration (fake ID for The Oculus)
    [4803] = 145, -- The Oculus - Band of Transmutation (fake ID for The Oculus)
    [4804] = 146, -- The Oculus - Band of Alignment (fake ID for The Oculus)
    [4806] = 158, -- Azjol-Nerub - Hadronox's Lair (fake ID for Azjol-Nerub)
    [4807] = 159, -- Azjol-Nerub - The Gilded Gate (fake ID for Azjol-Nerub)
    [4809] = 183, -- The Forge of Souls - Dungeon
    [4812] = 186, -- Icecrown Citadel - Raid
    [4813] = 184, -- Pit of Saron - Dungeon
    [4816] = 136, -- Utgarde Pinnacle - Lower Level (fake ID for Utgarde Pinnacle)
    [4817] = 137, -- Utgarde Pinnacle - Upper Level (fake ID for Utgarde Pinnacle)
    [4818] = 133, -- Utgarde Keep - Lower Level (fake ID for Utgarde Keep)
    [4819] = 134, -- Utgarde Keep - Middle Level (fake ID for Utgarde Keep)
    [4820] = 185, -- Halls of Reflection - Dungeon
    [4821] = 135, -- Utgarde Keep - Upper Level (fake ID for Utgarde Keep)
    [4830] = 190, -- Icecrown Citadel - Upper Spire (fake ID for ICC)
    [4987] = 200, -- The Ruby Sanctum - Raid
    --- These should not be needed from my limited testing
    -- [14284] = 114, -- Borean Tundra - Battleground
    -- [14285] = 118, -- Icecrown - Battleground
    -- [14286] = 119, -- Sholazar Basin - Battleground
    -- [14287] = 115, -- Dragonblight - Battleground
    -- [14288] = 123, -- Wintergrasp - Battleground
}

---@type table<UiMapId, AreaId>
ZoneDB.private.uiMapIdToAreaId = {
    [1426] = 1, -- Dun Morogh
    [1418] = 3, -- Badlands
    [1419] = 4, -- Blasted Lands
    [1435] = 8, -- Swamp of Sorrows
    [1431] = 10, -- Duskwood
    [1437] = 11, -- Wetlands
    [1429] = 12, -- Elwynn Forest
    [1411] = 14, -- Durotar
    [1445] = 15, -- Dustwallow Marsh
    [1447] = 16, -- Azshara
    [1413] = 17, -- The Barrens
    [1422] = 28, -- Western Plaguelands
    [1434] = 33, -- Stranglethorn Vale
    [1416] = 36, -- Alterac Mountains
    [1432] = 38, -- Loch Modan
    [1436] = 40, -- Westfall
    [1430] = 41, -- Deadwind Pass
    [1433] = 44, -- Redridge Mountains
    [1417] = 45, -- Arathi Highlands
    [1428] = 46, -- Burning Steppes
    [1425] = 47, -- The Hinterlands
    [1427] = 51, -- Searing Gorge
    [115]  = 65, -- Dragonblight
    [121]  = 66, -- Zul'Drak
    [120]  = 67, -- The Storm Peaks
    [1420] = 85, -- Tirisfal Glades
    [1421] = 130, -- Silverpine Forest
    [1423] = 139, -- Eastern Plaguelands
    [1438] = 141, -- Teldrassil
    [1439] = 148, -- Darkshore
    [133]  = 4818, -- Utgarde Keep - Lower Level (fake ID for Utgarde Keep)
    [134]  = 4819, -- Utgarde Keep - Middle Level (fake ID for Utgarde Keep)
    [135]  = 4821, -- Utgarde Keep - Upper Level (fake ID for Utgarde Keep)
    [310]  = 209, -- Shadowfang Keep - Dungeon
    [311]  = 209, -- Shadowfang Keep - Dungeon
    [312]  = 209, -- Shadowfang Keep - Dungeon
    [313]  = 209, -- Shadowfang Keep - Dungeon
    [314]  = 209, -- Shadowfang Keep - Dungeon
    [315]  = 209, -- Shadowfang Keep - Dungeon
    [316]  = 209, -- Shadowfang Keep - Dungeon
    [118]  = 210, -- Icecrown
    [1412] = 215, -- Mulgore
    [1424] = 267, -- Hillsbrad Foothills
    [1440] = 331, -- Ashenvale
    [1444] = 357, -- Feralas
    [1448] = 361, -- Felwood
    [116]  = 394, -- Grizzly Hills
    [1441] = 400, -- Thousand Needles
    [1443] = 405, -- Desolace
    [1442] = 406, -- Stonetalon Mountains
    [1446] = 440, -- Tanaris
    [1449] = 490, -- Un'Goro Crater
    [301]  = 491, -- Razorfen Kraul - Dungeon
    [1450] = 493, -- Moonglade
    [117]  = 495, -- Howling Fjord
    [1452] = 618, -- Winterspring
    [225]  = 717, -- The Stockade - Dungeon
    [279]  = 718, -- Wailing Caverns - Dungeon
    [221]  = 719, -- Blackfathom Deeps - Dungeon
    [222]  = 719, -- Blackfathom Deeps - Dungeon
    [223]  = 719, -- Blackfathom Deeps - Dungeon
    [226]  = 721, -- Gnomeregan - Dungeon
    [227]  = 721, -- Gnomeregan - Dungeon
    [228]  = 721, -- Gnomeregan - Dungeon
    [229]  = 721, -- Gnomeregan - Dungeon
    [300]  = 722, -- Razorfen Downs - Dungeon
    [302]  = 796, -- Scarlet Monastery - Dungeon
    [303]  = 796, -- Scarlet Monastery - Dungeon
    [304]  = 796, -- Scarlet Monastery - Dungeon
    [305]  = 796, -- Scarlet Monastery - Dungeon
    [219]  = 1176, -- Zul'Farrak - Dungeon
    [136]  = 4816, -- Utgarde Pinnacle - Lower Level (fake ID for Utgarde Pinnacle)
    [137]  = 4817, -- Utgarde Pinnacle - Upper Level (fake ID for Utgarde Pinnacle)
    [230]  = 1337, -- Uldaman - Dungeon
    [231]  = 1337, -- Uldaman - Dungeon
    [1451] = 1377, -- Silithus
    [220]  = 1477, -- The Temple of Atal'Hakkar - Dungeon
    [1458] = 1497, -- Undercity
    [1453] = 1519, -- Stormwind City
    [1455] = 1537, -- Ironforge
    [291]  = 1581, -- The Deadmines - Dungeon
    [292]  = 1581, -- The Deadmines - Dungeon
    [250]  = 1583, -- Blackrock Spire - Dungeon
    [251]  = 1583, -- Blackrock Spire - Dungeon
    [252]  = 1583, -- Blackrock Spire - Dungeon
    [253]  = 1583, -- Blackrock Spire - Dungeon
    [254]  = 1583, -- Blackrock Spire - Dungeon
    [255]  = 1583, -- Blackrock Spire - Dungeon
    [242]  = 1584, -- Blackrock Depths - Dungeon
    [243]  = 1584, -- Blackrock Depths - Dungeon
    [1454] = 1637, -- Orgrimmar
    [1456] = 1638, -- Thunder Bluff
    [1457] = 1657, -- Darnassus
    [233]  = 1977, -- Zul'Gurub - Raid
    [337]  = 1977, -- Zul'Gurub - Raid
    [317]  = 2017, -- Stratholme - Dungeon
    [318]  = 2017, -- Stratholme - Dungeon
    [280]  = 2100, -- Maraudon - Dungeon
    [281]  = 2100, -- Maraudon - Dungeon
    [248]  = 2159, -- Onyxia's Lair - Dungeon?
    [273]  = 2366, -- The Black Morass - Dungeon
    [274]  = 2367, -- Old Hillsbrad Foothills - Dungeon
    [213]  = 2437, -- Ragefire Chasm - Dungeon
    [234]  = 2557, -- Dire Maul - Dungeon
    [235]  = 2557, -- Dire Maul - Dungeon
    [236]  = 2557, -- Dire Maul - Dungeon
    [237]  = 2557, -- Dire Maul - Dungeon
    [238]  = 2557, -- Dire Maul - Dungeon
    [239]  = 2557, -- Dire Maul - Dungeon
    [240]  = 2557, -- Dire Maul - Dungeon
    [1459] = 2597, -- Alterac Valley - Battleground
    [287]  = 2677, -- Blackwing Lair - Raid
    [288]  = 2677, -- Blackwing Lair - Raid
    [289]  = 2677, -- Blackwing Lair - Raid
    [290]  = 2677, -- Blackwing Lair - Raid
    [232]  = 2717, -- Molten Core - Raid
    [127]  = 2817, -- Crystalsong Forest
    [1460] = 3277, -- Warsong Gulch - Battleground
    [1461] = 3358, -- Arathi Basin - Battleground
    [319]  = 3428, -- Ahn'Qiraj - Raid
    [320]  = 3428, -- Ahn'Qiraj - Raid
    [321]  = 3428, -- Ahn'Qiraj - Raid
    [247]  = 3429, -- Ruins of Ahn'Qiraj - Raid
    [1941] = 3430, -- Eversong Woods
    [1942] = 3433, -- Ghostlands
    [162]  = 3456, -- Naxxramas - Raid
    [163]  = 3456, -- Naxxramas - Raid
    [164]  = 3456, -- Naxxramas - Raid
    [165]  = 3456, -- Naxxramas - Raid
    [166]  = 3456, -- Naxxramas - Raid
    [167]  = 3456, -- Naxxramas - Raid
    [350]  = 3457, -- Karazhan - Raid
    [351]  = 3457, -- Karazhan - Raid
    [352]  = 3457, -- Karazhan - Raid
    [353]  = 3457, -- Karazhan - Raid
    [354]  = 3457, -- Karazhan - Raid
    [355]  = 3457, -- Karazhan - Raid
    [356]  = 3457, -- Karazhan - Raid
    [357]  = 3457, -- Karazhan - Raid
    [358]  = 3457, -- Karazhan - Raid
    [359]  = 3457, -- Karazhan - Raid
    [360]  = 3457, -- Karazhan - Raid
    [361]  = 3457, -- Karazhan - Raid
    [362]  = 3457, -- Karazhan - Raid
    [363]  = 3457, -- Karazhan - Raid
    [364]  = 3457, -- Karazhan - Raid
    [365]  = 3457, -- Karazhan - Raid
    [366]  = 3457, -- Karazhan - Raid
    [1944] = 3483, -- Hellfire Peninsula
    [1954] = 3487, -- Silvermoon City
    [1951] = 3518, -- Nagrand
    [1952] = 3519, -- Terokkar Forest
    [1948] = 3520, -- Shadowmoon Valley
    [1946] = 3521, -- Zangarmarsh
    [1949] = 3522, -- Blade's Edge Mountains
    [1953] = 3523, -- Netherstorm
    [1943] = 3524, -- Azuremyst Isle
    [1950] = 3525, -- Bloodmyst Isle
    --[246] = 3535, -- Hellfire Citadel - Dungeon This is hellfire citadel area in The Shattered halls], have to have it because mobs use this AreaId
    [114] = 3537, -- Borean Tundra
    [1947] = 3557, -- The Exodar
    [347] = 3562, -- Hellfire Ramparts - Dungeon
    [329] = 3606, -- Hyjal Summit - Raid
    [332] = 3607, -- Serpentshrine Cavern - Raid
    [1554] = 3607, -- Serpentshrine Cavern - Raid
    [1955] = 3703, -- Shattrath City
    [119] = 3711, -- Sholazar Basin
    [261] = 3713, -- The Blood Furnace - Dungeon
    [246] = 3714, -- The Shattered Halls - Dungeon
    [263] = 3715, -- The Steamvault - Dungeon
    [264] = 3715, -- The Steamvault - Dungeon
    [262] = 3716, -- The Underbog - Dungeon
    [265] = 3717, -- The Slave Pens - Dungeon
    [260] = 3789, -- Shadow Labyrinth - Dungeon
    [256] = 3790, -- Auchenai Crypts - Dungeon
    [257] = 3790, -- Auchenai Crypts - Dungeon
    [258] = 3791, -- Sethekk Halls - Dungeon
    [259] = 3791, -- Sethekk Halls - Dungeon
    [272] = 3792, -- Mana-Tombs - Dungeon
    [333] = 3805, -- Zul'Aman - Raid
    [1956] = 3820, -- Eye of the Storm - Battleground
    [331] = 3836, -- Magtheridon's Lair - Raid
    [334] = 3845, -- Tempest Keep - Raid
    [1555] = 3845, -- Tempest Keep - Raid
    [266] = 3847, -- The Botanica - Dungeon
    [269] = 3848, -- The Arcatraz - Dungeon
    [270] = 3848, -- The Arcatraz - Dungeon
    [271] = 3848, -- The Arcatraz - Dungeon
    [267] = 3849, -- The Mechanar - Dungeon
    [268] = 3849, -- The Mechanar - Dungeon
    [330] = 3923, -- Gruul's Lair - Raid
    [339] = 3959, -- Black Temple - Raid
    [335] = 4075, -- Sunwell Plateau - Raid
    [336] = 4075, -- Sunwell Plateau - Raid
    [1957] = 4080, -- Isle of Quel'Danas
    [130] = 4811, -- The Culling of Stratholme - Village (fake ID for The Culling of Stratholme)
    [131] = 4814, -- The Culling of Stratholme - City (fake ID for The Culling of Stratholme)
    [160] = 4822, -- Drak'Tharon Keep - Lower Level (fake ID for Drak'Tharon Keep)
    [161] = 4823, -- Drak'Tharon Keep - Upper Level (fake ID for Drak'Tharon Keep)
    [123] = 4197, -- Wintergrasp
    [2104] = 4197, -- Wintergrasp
    [142] = 4228, -- The Oculus - Dungeon
    [143] = 4801, -- The Oculus - Band of Variance (fake ID for The Oculus)
    [144] = 4802, -- The Oculus - Band of Acceleration (fake ID for The Oculus)
    [145] = 4803, -- The Oculus - Band of Transmutation (fake ID for The Oculus)
    [146] = 4804, -- The Oculus - Band of Alignment (fake ID for The Oculus)
    [140] = 4810, -- Halls of Stone - dungeon map (fake ID for Halls of Stone)
    [1375] = 4264, -- Halls of Stone - Dungeon
    [129] = 4805, -- The Nexus - dungeon map (fake ID for The Nexus)
    [138] = 4272, -- Halls of Lightning - Dungeon
    [147] = 4273, -- Ulduar - Raid
    [152] = 4273, -- Ulduar - Raid
    [139] = 4274, -- Halls of Lightning - The Terrestrial Watchtower (fake ID for Halls of Lightning)
    [157] = 4301, -- Azjol-Nerub - The Brood Pit (fake ID for Azjol-Nerub)
    [158] = 4806, -- Azjol-Nerub - Hadronox's Lair (fake ID for Azjol-Nerub)
    [159] = 4807, -- Azjol-Nerub - The Gilded Gate (fake ID for Azjol-Nerub)
    [124] = 4298, -- Plaguelands: The Scarlet Enclave
    [128] = 4384, -- Strand of the Ancients - Battleground
    [125] = 4395, -- Dalaran - Dungeon?
    [168] = 4415, -- The Violet Hold - Dungeon
    [153] = 4825, -- Gundrak - Lower Level (fake ID for Gundrak)
    [154] = 4824, -- Gundrak - Upper Level (fake ID for Gundrak)
    [155] = 4493, -- The Obsidian Sanctum - Raid
    [132] = 4808, -- Ahn'kahet: The Old Kingdom - dungeon map (fake ID for Ahn'kahet: The Old Kingdom)
    [141] = 4500, -- The Eye of Eternity - Raid
    [126] = 4560, -- The Underbelly - Sub zone of Dalaran
    [156] = 4603, -- Vault of Archavon - Raid
    [148] = 4657, -- Ulduar - The Antechamber of Ulduar
    [150] = 4659, -- Ulduar - The Descent of Madness (fake ID for Ulduar)
    [151] = 4660, -- Ulduar - The Spark of Imagination (fake ID for Ulduar)
    [149] = 4661, -- Ulduar - The Inner Sanctum of Ulduar (fake ID for Ulduar)
    [169] = 4710, -- Isle of Conquest - Battleground
    [172] = 4722, -- Trial of the Crusader - Raid
    [173] = 4722, -- Trial of the Crusader - Raid
    [171] = 4723, -- Trial of the Champion - Dungeon
    [170] = 4742, -- Hrothgar's Landing
    [183] = 4809, -- The Forge of Souls - Dungeon
    [186] = 4812, -- Icecrown Citadel - Raid
    [187] = 4812, -- Icecrown Citadel - Raid
    [188] = 4812, -- Icecrown Citadel - Raid
    [189] = 4812, -- Icecrown Citadel - Raid
    [190] = 4830, -- Icecrown Citadel - Uppe Spire (fake ID for ICC)
    [191] = 4812, -- Icecrown Citadel - Raid
    [192] = 4812, -- Icecrown Citadel - Raid
    [193] = 4812, -- Icecrown Citadel - Raid
    [184] = 4813, -- Pit of Saron - Dungeon
    [185] = 4820, -- Halls of Reflection - Dungeon
    [200] = 4987, -- The Ruby Sanctum - Raid
}

-- [areaId] = {"name", alternative areaId (a sub zone), parentId}
---@type table<AreaId, AreaCoordinate[]>
ZoneDB.private.dungeons = {
    [206] = {"Utgarde Keep",nil,495},
    [209] = {"Shadowfang Keep", 236, 130},
    [491] = {"Razorfen Kraul", 1717, 17},
    [717] = {"The Stockade", nil, 1519},
    [718] = {"Wailing Caverns", nil, 17},
    [719] = {"Blackfathom Deeps", 2797, 331},
    [721] = {"Gnomeregan", 133, 1},
    [722] = {"Razorfen Downs", 1316, 17},
    [796] = {"Scarlet Monastery", nil, 85},
    [1176] = {"Zul'Farrak", 978, 440},
    [1196] = {"Utgarde Pinnacle",nil,495},
    [1337] = {"Uldaman", 1517, 3},
    [1477] = {"The Temple of Atal'Hakkar", 1417, 8},
    [1581] = {"The Deadmines", nil, 40},
    [1583] = {"Blackrock Spire", nil, 51},
    [1584] = {"Blackrock Depths", nil, 51},
    [1585] = {"Blackrock Depths", nil, 51},
    [2017] = {"Stratholme", 2279, 139},
    [2057] = {"Scholomance", nil, 28},
    [2100] = {"Maraudon", nil, 405},
    [2366] = {"The Black Morass", nil, 440},
    [2367] = {"Old Hillsbrad Foothills", nil, 440},
    [2437] = {"Ragefire Chasm", nil, 1637},
    [2557] = {"Dire Maul", 2577, 357},
    [3456] = {"Naxxramas",nil,65},
    [3457] = {"Karazhan", nil, 41},
    [3562] = {"Hellfire Ramparts",nil,3483},
    [3606] = {"Hyjal Summit", nil, 440},
    [3713] = {"The Blood Furnace",nil,3483},
    [3714] = {"The Shattered Halls",3535,3483},
    [3715] = {"The Steamvault",nil,3521},
    [3716] = {"The Underbog",nil,3521},
    [3717] = {"The Slave Pens",nil,3521},
    [3789] = {"Shadow Labyrinth",nil,3519},
    [3790] = {"Auchenai Crypts",nil,3519},
    [3791] = {"Sethekk Halls",nil,3519},
    [3792] = {"Mana-Tombs",nil,3519},
    [3805] = {"Zul'Aman",nil,3433},
    [3836] = {"Magtheridon's Lair",nil,3483},
    [3847] = {"The Botanica",nil,3523},
    [3848] = {"The Arcatraz",nil,3523},
    [3849] = {"The Mechanar",nil,3523},
    [3959] = {"Black Temple",nil,3520},
    [4075] = {"Sunwell Plateau",nil,4080},
    [4100] = {"The Culling of Stratholme",nil,440},
    [4131] = {"Magisters' Terrace",nil,4080},
    [4196] = {"Drak'Tharon Keep",nil,66},
    [4265] = {"The Nexus",nil,3537},
    [4228] = {"The Oculus",nil,3537},
    [4264] = {"Halls of Stone",nil,67},
    [4272] = {"Halls of Lightning",nil,67},
    [4273] = {"Ulduar",nil,67},
    [4277] = {"Azjol-Nerub",nil,65},
    [4415] = {"The Violet Hold",nil,4395},
    [4416] = {"Gundrak",nil,66},
    [4493] = {"The Obsidian Sanctum",nil,65},
    [4494] = {"Ahn'kahet: The Old Kingdom",nil,65},
    [4500] = {"The Eye of Eternity",nil,3537},
    [4603] = {"Vault of Archavon",nil,4197},
    [4722] = {"Trial of the Crusader",nil,210},
    [4723] = {"Trial of the Champion",nil,210},
    [4809] = {"The Forge of Souls",nil,210},
    [4812] = {"Icecrown Citadel",nil,210},
    [4813] = {"Pit of Saron",nil,210},
    [4820] = {"Halls of Reflection",nil,210},
    [4987] = {"The Ruby Sanctum",nil,65},
}



--- {"name", alternative areaId (a sub zone), parentId}
---@type table<AreaId, { [1]: Name, [2]: AreaId, [3]: AreaId }>
ZoneDB.private.dungeonLocations = {
    [206] = {{495, 57.3, 46.8}},
    [209] = {{130, 45, 68.7}},
    [491] = {{17, 42.3, 89.9}},
    [717] = {(Questie.IsWotlk and {1519, 52.4, 70}) or {1519, 40.5, 55.9}},
    [718] = {{17, 46, 36.5}},
    [719] = {{331, 14.1, 14.4}},
    [721] = {{1, 24.4, 39.8}},
    [722] = {{17, 50.8, 92.8}},
    [796] = {{85, 83, 34}},
    [1176] = {{440, 38.7, 20.1}},
    [1196] = {{495, 57.3, 46.8}},
    [1337] = {{3, 44.4, 12.2}, {3, 65.2, 43.5}},
    [1417] = {{8, 69.9, 53.5}},
    [1477] = {{8, 69.9, 53.5}},
    [1581] = {{40, 42.5, 71.1}},
    [1583] = {{51, 34.8, 84.8}, {46, 29.5, 38.2}},
    [1584] = {{51, 34.8, 84.8}, {46, 29.5, 38.2}},
    [1585] = {{51, 34.8, 84.8}, {46, 29.5, 38.2}},
    [1977] = {{33, 53.8, 17.5}},
    [2017] = {{139, 27.2, 15.5}, {139, 43.5, 19.5}},
    [2057] = {{28, 69.7, 73.2}},
    [2100] = {{405, 29.5, 62.5}},
    [2159] = {{15, 52.4, 76.4}},
    [2257] = {Questie.IsWotlk and {1519, 72, 28} or {1519, 67.6, 4.1}, {1537, 84.1, 53.1}},
    [2366] = {{440, 65.7, 49.8}},
    [2367] = {{440, 65.7, 49.8}},
    [2437] = {{1637, 51.7, 49.8}},
    [2557] = {{357, 59.2, 45.1}},
    [3456] = {Questie.IsWotlk and {65, 87.4, 51.1} or {139, 39.9, 25.8}},
    [2597] = {{36, 66.6, 51.3},},
    [2677] = {{51, 34.8, 84.8}, {46, 29.5, 38.2}},
    [2717] = {{51, 34.8, 84.8}, {46, 29.5, 38.2}},
    [2917] = {{1637, 40.4, 68.3}},
    [2918] = {{1519, 72.7, 54}},
    [3428] = {{1377, 28.6, 92.3}},
    [3429] = {{1377, 28.6, 92.3}},
    [3457] = {{41, 46.9, 74.7}},
    [3562] = {{3483, 47.7, 53.6}},
    [3606] = {{440, 65.7, 49.8}},
    [3607] = {{3521, 50.4, 40.9}},
    [3713] = {{3483, 46.0, 51.8}},
    [3714] = {{3483, 47.7, 52.0}},
    [3715] = {{3521, 50.4, 40.9}},
    [3716] = {{3521, 50.4, 40.9}},
    [3717] = {{3521, 50.4, 40.9}},
    [3789] = {{3519, 39.6, 71.0}},
    [3790] = {{3519, 36.1, 65.6}},
    [3791] = {{3519, 43.2, 65.6}},
    [3792] = {{3519, 39.7, 60.2}},
    [3805] = {{3433, 82.25, 64.3}},
    [3836] = {{3483, 46.55, 52.81}},
    [3845] = {{3523, 73.7, 63.7}},
    [3847] = {{3523, 71.7, 55.0}},
    [3848] = {{3523, 74.4, 57.7}},
    [3849] = {{3523, 70.6, 69.7}},
    [3923] = {{3522, 68.7, 24.3}},
    [3959] = {{3520, 71.1, 46.3}},
    [4075] = {{4080, 44.5, 45.3}},
    [4100] = {{440, 65.7, 49.8}},
    [4131] = {{4080, 61.2, 30.9}},
    [4196] = {{66, 29.0, 83.9},{394, 17.5, 27.0}},
    [4265] = {{3537, 27.6, 26.6}},
    [4228] = {{3537, 27.6, 26.6}},
    [4264] = {{67, 39.6, 26.9}},
    [4272] = {{67, 45.4, 21.4}},
    [4273] = {{67, 41.6, 17.8}},
    [4277] = {{65, 26.2, 49.6}},
    [4415] = {{4395, 66.8, 68.2}},
    [4416] = {{66, 76.2, 21.1},{66, 81.2, 28.9}},
    [4493] = {{65, 59.6, 51.1}},
    [4494] = {{65, 26.2, 49.6}},
    [4500] = {{3537, 27.6, 26.6}},
    [4603] = {{4197, 50.5, 16.4}},
    [4722] = {{210, 75.1, 21.8}},
    [4723] = {{210, 74.2, 20.5}},
    [4809] = {{210, 52.6, 89.4}},
    [4812] = {{210, 53.3, 85.5}},
    [4813] = {{210, 52.6, 89.4}},
    [4820] = {{210, 52.6, 89.4}},
    [4987] = {{65, 59.6, 51.1}},
    [7307] = {{51, 34.8, 84.8}, {46, 29.5, 38.2}},
}

-- [dungeonZone] = parentZone
---@type table<AreaId, AreaId>
ZoneDB.private.dungeonParentZones = {
    [236] = 209,
    [1717] = 491,
    [2797] = 719,
    [133] = 721,
    [1316] = 722,
    [978] = 1176,
    [1517] = 1337,
    [1417] = 1477,
    [2279] = 2017,
    [2577] = 2557,
}

--? If you want to add something overwrite the data after the table
--! Generated table, add something manually here and i'll kill you //Logon

---@type table<AreaId, AreaId> table<SubAreaId, ParentAreaId>
ZoneDB.private.subZoneToParentZone = {
  [2] = 40, -- Longshore -> Westfall
  [7] = 33, -- Blackwater Cove -> Stranglethorn Vale
  [9] = 12, -- Northshire Valley -> Elwynn Forest
  [13] = 10, -- The World Tree -> Duskwood
  [18] = 12, -- Crystal Lake -> Elwynn Forest
  [19] = 33, -- Zul'Gurub -> Stranglethorn Vale
  [20] = 40, -- Moonbrook -> Westfall
  [23] = 12, -- Northshire River -> Elwynn Forest
  [24] = 12, -- Northshire Abbey -> Elwynn Forest
  [26] = 40, -- Lighthouse -> Westfall
  [32] = 10, -- The Cemetary -> Duskwood
  [34] = 12, -- Echo Ridge Mine -> Elwynn Forest
  [35] = 33, -- Booty Bay -> Stranglethorn Vale
  [37] = 33, -- Lake Nazferiti -> Stranglethorn Vale
  [42] = 10, -- Darkshire -> Duskwood
  [43] = 33, -- Wild Shore -> Stranglethorn Vale
  [49] = 22, -- Dead Man's Hole -> Programmer Isle
  [53] = 12, -- Thieves Camp -> Elwynn Forest
  [54] = 12, -- Jasperlode Mine -> Elwynn Forest
  [55] = 12, -- Valley of Heroes UNUSED -> Elwynn Forest
  [56] = 12, -- Heroes' Vigil -> Elwynn Forest
  [57] = 12, -- Fargodeep Mine -> Elwynn Forest
  [59] = 12, -- Northshire Vineyards -> Elwynn Forest
  [60] = 12, -- Forest's Edge -> Elwynn Forest
  [61] = 12, -- Thunder Falls -> Elwynn Forest
  [62] = 12, -- Brackwell Pumpkin Patch -> Elwynn Forest
  [63] = 12, -- The Stonefield Farm -> Elwynn Forest
  [64] = 12, -- The Maclure Vineyards -> Elwynn Forest
  [68] = 44, -- Lake Everstill -> Redridge Mountains
  [69] = 44, -- Lakeshire -> Redridge Mountains
  [70] = 44, -- Stonewatch -> Redridge Mountains
  [71] = 44, -- Stonewatch Falls -> Redridge Mountains
  [72] = 4, -- The Dark Portal -> Blasted Lands
  [73] = 4, -- The Tainted Scar -> Blasted Lands
  [74] = 8, -- Pool of Tears -> Swamp of Sorrows
  [75] = 8, -- Stonard -> Swamp of Sorrows
  [76] = 8, -- Fallow Sanctuary -> Swamp of Sorrows
  [77] = 1, -- Anvilmar -> Dun Morogh
  [80] = 12, -- Stormwind Mountains -> Elwynn Forest
  [81] = 22, -- Jeff NE Quadrant Changed -> Programmer Isle
  [82] = 22, -- Jeff NW Quadrant -> Programmer Isle
  [83] = 22, -- Jeff SE Quadrant -> Programmer Isle
  [84] = 22, -- Jeff SW Quadrant -> Programmer Isle
  [86] = 12, -- Stone Cairn Lake -> Elwynn Forest
  [87] = 12, -- Goldshire -> Elwynn Forest
  [88] = 12, -- Eastvale Logging Camp -> Elwynn Forest
  [89] = 12, -- Mirror Lake Orchard -> Elwynn Forest
  [91] = 12, -- Tower of Azora -> Elwynn Forest
  [92] = 12, -- Mirror Lake -> Elwynn Forest
  [93] = 10, -- Vul'Gol Ogre Mound -> Duskwood
  [94] = 10, -- Raven Hill -> Duskwood
  [95] = 44, -- Redridge Canyons -> Redridge Mountains
  [96] = 44, -- Tower of Ilgalar -> Redridge Mountains
  [97] = 44, -- Alther's Mill -> Redridge Mountains
  [98] = 44, -- Rethban Caverns -> Redridge Mountains
  [99] = 33, -- Rebel Camp -> Stranglethorn Vale
  [100] = 33, -- Nesingwary's Expedition -> Stranglethorn Vale
  [101] = 33, -- Kurzen's Compound -> Stranglethorn Vale
  [102] = 33, -- Ruins of Zul'Kunda -> Stranglethorn Vale
  [103] = 33, -- Ruins of Zul'Mamwe -> Stranglethorn Vale
  [104] = 33, -- The Vile Reef -> Stranglethorn Vale
  [105] = 33, -- Mosh'Ogg Ogre Mound -> Stranglethorn Vale
  [106] = 33, -- The Stockpile -> Stranglethorn Vale
  [107] = 40, -- Saldean's Farm -> Westfall
  [108] = 40, -- Sentinel Hill -> Westfall
  [109] = 40, -- Furlbrow's Pumpkin Farm -> Westfall
  [111] = 40, -- Jangolode Mine -> Westfall
  [113] = 40, -- Gold Coast Quarry -> Westfall
  [115] = 40, -- Westfall Lighthouse -> Westfall
  [116] = 8, -- Misty Valley -> Swamp of Sorrows
  [117] = 33, -- Grom'gol Base Camp -> Stranglethorn Vale
  [118] = 11, -- Whelgar's Excavation Site -> Wetlands
  [120] = 12, -- Westbrook Garrison -> Elwynn Forest
  [121] = 10, -- Tranquil Gardens Cemetery -> Duskwood
  [122] = 33, -- Zuuldaia Ruins -> Stranglethorn Vale
  [123] = 33, -- Bal'lal Ruins -> Stranglethorn Vale
  [125] = 33, -- Kal'ai Ruins -> Stranglethorn Vale
  [126] = 33, -- Tkashi Ruins -> Stranglethorn Vale
  [127] = 33, -- Balia'mah Ruins -> Stranglethorn Vale
  [128] = 33, -- Ziata'jai Ruins -> Stranglethorn Vale
  [129] = 33, -- Mizjah Ruins -> Stranglethorn Vale
  [131] = 1, -- Kharanos -> Dun Morogh
  [132] = 1, -- Coldridge Valley -> Dun Morogh
  [133] = 721, -- Gnomeregan -> Gnomeregan
  [134] = 1, -- Gol'Bolar Quarry -> Dun Morogh
  [135] = 1, -- Frostmane Hold -> Dun Morogh
  [136] = 1, -- The Grizzled Den -> Dun Morogh
  [137] = 1, -- Brewnall Village -> Dun Morogh
  [138] = 1, -- Misty Pine Refuge -> Dun Morogh
  [142] = 38, -- Ironband's Excavation Site -> Loch Modan
  [143] = 38, -- Mo'grosh Stronghold -> Loch Modan
  [144] = 38, -- Thelsamar -> Loch Modan
  [145] = 38, -- Algaz Gate -> Loch Modan
  [146] = 38, -- Stonewrought Dam -> Loch Modan
  [147] = 38, -- The Farstrider Lodge -> Loch Modan
  [149] = 38, -- Silver Stream Mine -> Loch Modan
  [150] = 11, -- Menethil Harbor -> Wetlands
  [152] = 85, -- The Bulwark -> Tirisfal Glades
  [153] = 85, -- Ruins of Lordaeron -> Tirisfal Glades
  [154] = 85, -- Deathknell -> Tirisfal Glades
  [155] = 85, -- Night Web's Hollow -> Tirisfal Glades
  [156] = 85, -- Solliden Farmstead -> Tirisfal Glades
  [157] = 85, -- Agamand Mills -> Tirisfal Glades
  [158] = 85, -- Agamand Family Crypt -> Tirisfal Glades
  [159] = 85, -- Brill -> Tirisfal Glades
  [160] = 85, -- Whispering Gardens -> Tirisfal Glades
  [161] = 85, -- Terrace of Repose -> Tirisfal Glades
  [162] = 85, -- Brightwater Lake -> Tirisfal Glades
  [163] = 85, -- Gunther's Retreat -> Tirisfal Glades
  [164] = 85, -- Garren's Haunt -> Tirisfal Glades
  [165] = 85, -- Balnir Farmstead -> Tirisfal Glades
  [166] = 85, -- Cold Hearth Manor -> Tirisfal Glades
  [167] = 85, -- Crusader Outpost -> Tirisfal Glades
  [168] = 85, -- The North Coast -> Tirisfal Glades
  [169] = 85, -- Whispering Shore -> Tirisfal Glades
  [172] = 130, -- Fenris Isle -> Silverpine Forest
  [173] = 85, -- Faol's Rest -> Tirisfal Glades
  [186] = 141, -- Dolanaar -> Teldrassil
  [187] = 141, -- Darnassus UNUSED -> Teldrassil
  [188] = 141, -- Shadowglen -> Teldrassil
  [189] = 1, -- Steelgrill's Depot -> Dun Morogh
  [190] = 28, -- Hearthglen -> Western Plaguelands
  [192] = 28, -- Northridge Lumber Camp -> Western Plaguelands
  [193] = 28, -- Ruins of Andorhal -> Western Plaguelands
  [195] = 28, -- School of Necromancy -> Western Plaguelands
  [196] = 28, -- Uther's Tomb -> Western Plaguelands
  [197] = 28, -- Sorrow Hill -> Western Plaguelands
  [198] = 28, -- The Weeping Cave -> Western Plaguelands
  [199] = 28, -- Felstone Field -> Western Plaguelands
  [200] = 28, -- Dalson's Tears -> Western Plaguelands
  [201] = 28, -- Gahrron's Withering -> Western Plaguelands
  [202] = 28, -- The Writhing Haunt -> Western Plaguelands
  [203] = 28, -- Mardenholde Keep -> Western Plaguelands
  [204] = 130, -- Pyrewood Village -> Silverpine Forest
  [205] = 11, -- Dun Modr -> Wetlands
  [211] = 1, -- Iceflow Lake -> Dun Morogh
  [212] = 1, -- Helm's Bed Lake -> Dun Morogh
  [213] = 130, -- Deep Elem Mine -> Silverpine Forest
  [214] = 207, -- The Great Sea -> The Great Sea
  [219] = 40, -- Alexston Farmstead -> Westfall
  [220] = 215, -- Red Cloud Mesa -> Mulgore
  [221] = 215, -- Camp Narache -> Mulgore
  [222] = 215, -- Bloodhoof Village -> Mulgore
  [223] = 215, -- Stonebull Lake -> Mulgore
  [224] = 215, -- Ravaged Caravan -> Mulgore
  [225] = 215, -- Red Rocks -> Mulgore
  [226] = 130, -- The Skittering Dark -> Silverpine Forest
  [227] = 130, -- Valgan's Field -> Silverpine Forest
  [228] = 130, -- The Sepulcher -> Silverpine Forest
  [229] = 130, -- Olsen's Farthing -> Silverpine Forest
  [230] = 130, -- The Greymane Wall -> Silverpine Forest
  [231] = 130, -- Beren's Peril -> Silverpine Forest
  [232] = 130, -- The Dawning Isles -> Silverpine Forest
  [233] = 130, -- Ambermill -> Silverpine Forest
  [235] = 130, -- Fenris Keep -> Silverpine Forest
  [236] = 130, -- Shadowfang Keep -> Silverpine Forest
  [237] = 130, -- The Decrepit Ferry -> Silverpine Forest
  [238] = 130, -- Malden's Orchard -> Silverpine Forest
  [239] = 130, -- The Ivar Patch -> Silverpine Forest
  [240] = 130, -- The Dead Field -> Silverpine Forest
  [241] = 10, -- The Rotting Orchard -> Duskwood
  [242] = 10, -- Brightwood Grove -> Duskwood
  [243] = 10, -- Forlorn Rowe -> Duskwood
  [244] = 10, -- The Whipple Estate -> Duskwood
  [245] = 10, -- The Yorgen Farmstead -> Duskwood
  [246] = 51, -- The Cauldron -> Searing Gorge
  [247] = 51, -- Grimesilt Dig Site -> Searing Gorge
  [249] = 46, -- Dreadmaul Rock -> Burning Steppes
  [250] = 46, -- Ruins of Thaurissan -> Burning Steppes
  [251] = 46, -- Flame Crest -> Burning Steppes
  [252] = 46, -- Blackrock Stronghold -> Burning Steppes
  [253] = 46, -- The Pillar of Ash -> Burning Steppes
  [254] = 25, -- Blackrock Mountain -> Blackrock Mountain
  [255] = 46, -- Altar of Storms -> Burning Steppes
  [256] = 141, -- Aldrassil -> Teldrassil
  [257] = 141, -- Shadowthread Cave -> Teldrassil
  [258] = 141, -- Fel Rock -> Teldrassil
  [259] = 141, -- Lake Al'Ameth -> Teldrassil
  [260] = 141, -- Starbreeze Village -> Teldrassil
  [261] = 141, -- Gnarlpine Hold -> Teldrassil
  [262] = 141, -- Ban'ethil Barrow Den -> Teldrassil
  [263] = 141, -- The Cleft -> Teldrassil
  [264] = 141, -- The Oracle Glade -> Teldrassil
  [265] = 141, -- Wellspring River -> Teldrassil
  [266] = 141, -- Wellspring Lake -> Teldrassil
  [271] = 267, -- Southshore -> Hillsbrad Foothills
  [272] = 267, -- Tarren Mill -> Hillsbrad Foothills
  [275] = 267, -- Durnholde Keep -> Hillsbrad Foothills
  [277] = 36, -- The Foothill Caverns -> Alterac Mountains
  [278] = 36, -- Lordamere Internment Camp -> Alterac Mountains
  [279] = 36, -- Dalaran Crater -> Alterac Mountains
  [280] = 36, -- Strahnbrad -> Alterac Mountains
  [281] = 36, -- Ruins of Alterac -> Alterac Mountains
  [282] = 36, -- Crushridge Hold -> Alterac Mountains
  [283] = 36, -- Slaughter Hollow -> Alterac Mountains
  [284] = 36, -- The Uplands -> Alterac Mountains
  [285] = 267, -- Southpoint Tower -> Hillsbrad Foothills
  [286] = 267, -- Hillsbrad Fields -> Hillsbrad Foothills
  [287] = 267, -- Hillsbrad -> Hillsbrad Foothills
  [288] = 267, -- Azurelode Mine -> Hillsbrad Foothills
  [289] = 267, -- Nethander Stead -> Hillsbrad Foothills
  [290] = 267, -- Dun Garok -> Hillsbrad Foothills
  [294] = 267, -- Eastern Strand -> Hillsbrad Foothills
  [295] = 267, -- Western Strand -> Hillsbrad Foothills
  [297] = 33, -- Jaguero Isle -> Stranglethorn Vale
  [298] = 11, -- Baradin Bay -> Wetlands
  [299] = 11, -- Menethil Bay -> Wetlands
  [300] = 8, -- Misty Reed Strand -> Swamp of Sorrows
  [301] = 33, -- The Savage Coast -> Stranglethorn Vale
  [302] = 33, -- The Crystal Shore -> Stranglethorn Vale
  [303] = 33, -- Shell Beach -> Stranglethorn Vale
  [305] = 130, -- North Tide's Run -> Silverpine Forest
  [306] = 130, -- South Tide's Run -> Silverpine Forest
  [307] = 47, -- The Overlook Cliffs -> The Hinterlands
  [309] = 11, -- Ironbeard's Tomb -> Wetlands
  [310] = 33, -- Crystalvein Mine -> Stranglethorn Vale
  [311] = 33, -- Ruins of Aboraz -> Stranglethorn Vale
  [312] = 33, -- Janeiro's Point -> Stranglethorn Vale
  [313] = 45, -- Northfold Manor -> Arathi Highlands
  [314] = 45, -- Go'Shek Farm -> Arathi Highlands
  [315] = 45, -- Dabyrie's Farmstead -> Arathi Highlands
  [316] = 45, -- Boulderfist Hall -> Arathi Highlands
  [317] = 45, -- Witherbark Village -> Arathi Highlands
  [318] = 45, -- Drywhisker Gorge -> Arathi Highlands
  [320] = 45, -- Refuge Pointe -> Arathi Highlands
  [321] = 45, -- Hammerfall -> Arathi Highlands
  [322] = 45, -- Blackwater Shipwrecks -> Arathi Highlands
  [323] = 45, -- O'Breen's Camp -> Arathi Highlands
  [324] = 45, -- Stromgarde Keep -> Arathi Highlands
  [325] = 45, -- The Tower of Arathor -> Arathi Highlands
  [326] = 45, -- The Sanctum -> Arathi Highlands
  [327] = 45, -- Faldir's Cove -> Arathi Highlands
  [328] = 45, -- The Drowned Reef -> Arathi Highlands
  [333] = 45, -- Circle of East Binding -> Arathi Highlands
  [334] = 45, -- Circle of West Binding -> Arathi Highlands
  [335] = 45, -- Circle of Inner Binding -> Arathi Highlands
  [336] = 45, -- Circle of Outer Binding -> Arathi Highlands
  [337] = 3, -- Apocryphan's Rest -> Badlands
  [338] = 3, -- Angor Fortress -> Badlands
  [339] = 3, -- Lethlor Ravine -> Badlands
  [340] = 3, -- Kargath -> Badlands
  [341] = 3, -- Camp Kosh -> Badlands
  [342] = 3, -- Camp Boff -> Badlands
  [343] = 3, -- Camp Wurg -> Badlands
  [344] = 3, -- Camp Cagg -> Badlands
  [345] = 3, -- Agmond's End -> Badlands
  [346] = 3, -- Hammertoe's Digsite -> Badlands
  [347] = 3, -- Dustbelch Grotto -> Badlands
  [348] = 47, -- Aerie Peak -> The Hinterlands
  [349] = 47, -- Wildhammer Keep -> The Hinterlands
  [350] = 47, -- Quel'Danil Lodge -> The Hinterlands
  [351] = 47, -- Skulk Rock -> The Hinterlands
  [352] = 47, -- Zun'watha -> The Hinterlands
  [353] = 47, -- Shadra'Alor -> The Hinterlands
  [354] = 47, -- Jintha'Alor -> The Hinterlands
  [355] = 47, -- The Altar of Zul -> The Hinterlands
  [356] = 47, -- Seradane -> The Hinterlands
  [358] = 215, -- Brambleblade Ravine -> Mulgore
  [359] = 17, -- Bael Modan -> The Barrens
  [360] = 215, -- The Venture Co. Mine -> Mulgore
  [362] = 14, -- Razor Hill -> Durotar
  [363] = 14, -- Valley of Trials -> Durotar
  [364] = 14, -- The Den -> Durotar
  [365] = 14, -- Burning Blade Coven -> Durotar
  [366] = 14, -- Kolkar Crag -> Durotar
  [367] = 14, -- Sen'jin Village -> Durotar
  [368] = 14, -- Echo Isles -> Durotar
  [369] = 14, -- Thunder Ridge -> Durotar
  [370] = 14, -- Drygulch Ravine -> Durotar
  [371] = 14, -- Dustwind Cave -> Durotar
  [372] = 14, -- Tiragarde Keep -> Durotar
  [373] = 14, -- Scuttle Coast -> Durotar
  [374] = 14, -- Bladefist Bay -> Durotar
  [375] = 14, -- Deadeye Shore -> Durotar
  [378] = 17, -- Camp Taurajo -> The Barrens
  [379] = 17, -- Far Watch Post -> The Barrens
  [380] = 17, -- The Crossroads -> The Barrens
  [381] = 17, -- Boulder Lode Mine -> The Barrens
  [382] = 17, -- The Sludge Fen -> The Barrens
  [383] = 17, -- The Dry Hills -> The Barrens
  [384] = 17, -- Dreadmist Peak -> The Barrens
  [385] = 17, -- Northwatch Hold -> The Barrens
  [386] = 17, -- The Forgotten Pools -> The Barrens
  [387] = 17, -- Lushwater Oasis -> The Barrens
  [388] = 17, -- The Stagnant Oasis -> The Barrens
  [390] = 17, -- Field of Giants -> The Barrens
  [391] = 17, -- The Merchant Coast -> The Barrens
  [392] = 17, -- Ratchet -> The Barrens
  [393] = 14, -- Darkspear Strand -> Durotar
  [395] = 394, -- Grizzlemaw -> Grizzly Hills
  [396] = 215, -- Winterhoof Water Well -> Mulgore
  [397] = 215, -- Thunderhorn Water Well -> Mulgore
  [398] = 215, -- Wildmane Water Well -> Mulgore
  [399] = 215, -- Skyline Ridge -> Mulgore
  [401] = 17, -- The Tidus Stair -> The Barrens
  [403] = 15, -- Shady Rest Inn -> Dustwallow Marsh
  [404] = 215, -- Bael'dun Digsite -> Mulgore
  [407] = 14, -- Orgrimmar UNUSED -> Durotar
  [410] = 14, -- Razorwind Canyon -> Durotar
  [411] = 331, -- Bathran's Haunt -> Ashenvale
  [412] = 331, -- The Ruins of Ordil'Aran -> Ashenvale
  [413] = 331, -- Maestra's Post -> Ashenvale
  [414] = 331, -- The Zoram Strand -> Ashenvale
  [415] = 331, -- Astranaar -> Ashenvale
  [416] = 331, -- The Shrine of Aessina -> Ashenvale
  [417] = 331, -- Fire Scar Shrine -> Ashenvale
  [418] = 331, -- The Ruins of Stardust -> Ashenvale
  [419] = 331, -- The Howling Vale -> Ashenvale
  [420] = 331, -- Silverwind Refuge -> Ashenvale
  [421] = 331, -- Mystral Lake -> Ashenvale
  [422] = 331, -- Fallen Sky Lake -> Ashenvale
  [424] = 331, -- Iris Lake -> Ashenvale
  [425] = 331, -- Moonwell -> Ashenvale
  [426] = 331, -- Raynewood Retreat -> Ashenvale
  [427] = 331, -- The Shady Nook -> Ashenvale
  [428] = 331, -- Night Run -> Ashenvale
  [429] = 331, -- Xavian -> Ashenvale
  [430] = 331, -- Satyrnaar -> Ashenvale
  [431] = 331, -- Splintertree Post -> Ashenvale
  [432] = 331, -- The Dor'Danil Barrow Den -> Ashenvale
  [433] = 331, -- Falfarren River -> Ashenvale
  [434] = 331, -- Felfire Hill -> Ashenvale
  [435] = 331, -- Demon Fall Canyon -> Ashenvale
  [436] = 331, -- Demon Fall Ridge -> Ashenvale
  [437] = 331, -- Warsong Lumber Camp -> Ashenvale
  [438] = 331, -- Bough Shadow -> Ashenvale
  [439] = 400, -- The Shimmering Flats -> Thousand Needles
  [441] = 331, -- Lake Falathim -> Ashenvale
  [442] = 148, -- Auberdine -> Darkshore
  [443] = 148, -- Ruins of Mathystra -> Darkshore
  [444] = 148, -- Tower of Althalaxx -> Darkshore
  [445] = 148, -- Cliffspring Falls -> Darkshore
  [446] = 148, -- Bashal'Aran -> Darkshore
  [447] = 148, -- Ameth'Aran -> Darkshore
  [448] = 148, -- Grove of the Ancients -> Darkshore
  [449] = 148, -- The Master's Glaive -> Darkshore
  [450] = 148, -- Remtravel's Excavation -> Darkshore
  [452] = 148, -- Mist's Edge -> Darkshore
  [453] = 148, -- The Long Wash -> Darkshore
  [454] = 148, -- Wildbend River -> Darkshore
  [455] = 148, -- Blackwood Den -> Darkshore
  [456] = 148, -- Cliffspring River -> Darkshore
  [458] = 17, -- Gold Road -> The Barrens
  [459] = 85, -- Scarlet Watch Post -> Tirisfal Glades
  [460] = 406, -- Sun Rock Retreat -> Stonetalon Mountains
  [461] = 406, -- Windshear Crag -> Stonetalon Mountains
  [463] = 406, -- Cragpool Lake -> Stonetalon Mountains
  [464] = 406, -- Mirkfallon Lake -> Stonetalon Mountains
  [465] = 406, -- The Charred Vale -> Stonetalon Mountains
  [466] = 406, -- Valley of the Bloodfuries -> Stonetalon Mountains
  [467] = 406, -- Stonetalon Peak -> Stonetalon Mountains
  [468] = 406, -- The Talon Den -> Stonetalon Mountains
  [469] = 406, -- Greatwood Vale -> Stonetalon Mountains
  [470] = 215, -- Thunder Bluff UNUSED -> Mulgore
  [471] = 215, -- Brave Wind Mesa -> Mulgore
  [472] = 215, -- Fire Stone Mesa -> Mulgore
  [473] = 215, -- Mantle Rock -> Mulgore
  [474] = 215, -- Hunter Rise UNUSED -> Mulgore
  [475] = 215, -- Spirit RiseUNUSED -> Mulgore
  [476] = 215, -- Elder RiseUNUSED -> Mulgore
  [477] = 33, -- Ruins of Jubuwal -> Stranglethorn Vale
  [478] = 141, -- Pools of Arlithrien -> Teldrassil
  [479] = 400, -- The Rustmaul Dig Site -> Thousand Needles
  [480] = 400, -- Camp E'thok -> Thousand Needles
  [481] = 400, -- Splithoof Crag -> Thousand Needles
  [482] = 400, -- Highperch -> Thousand Needles
  [483] = 400, -- The Screeching Canyon -> Thousand Needles
  [484] = 400, -- Freewind Post -> Thousand Needles
  [485] = 400, -- The Great Lift -> Thousand Needles
  [486] = 400, -- Galak Hold -> Thousand Needles
  [487] = 400, -- Roguefeather Den -> Thousand Needles
  [488] = 400, -- The Weathered Nook -> Thousand Needles
  [489] = 357, -- Thalanaar -> Feralas
  [492] = 10, -- Raven Hill Cemetery -> Duskwood
  [496] = 15, -- Brackenwall Village -> Dustwallow Marsh
  [497] = 15, -- Swamplight Manor -> Dustwallow Marsh
  [498] = 15, -- Bloodfen Burrow -> Dustwallow Marsh
  [499] = 15, -- Darkmist Cavern -> Dustwallow Marsh
  [500] = 15, -- Moggle Point -> Dustwallow Marsh
  [501] = 15, -- Beezil's Wreck -> Dustwallow Marsh
  [502] = 15, -- Witch Hill -> Dustwallow Marsh
  [503] = 15, -- Sentry Point -> Dustwallow Marsh
  [504] = 15, -- North Point Tower -> Dustwallow Marsh
  [505] = 15, -- West Point Tower -> Dustwallow Marsh
  [506] = 15, -- Lost Point -> Dustwallow Marsh
  [507] = 15, -- Bluefen -> Dustwallow Marsh
  [508] = 15, -- Stonemaul Ruins -> Dustwallow Marsh
  [509] = 15, -- The Den of Flame -> Dustwallow Marsh
  [510] = 15, -- The Dragonmurk -> Dustwallow Marsh
  [511] = 15, -- Wyrmbog -> Dustwallow Marsh
  [512] = 15, -- Blackhoof Village -> Dustwallow Marsh
  [513] = 15, -- Theramore Isle -> Dustwallow Marsh
  [514] = 15, -- Foothold Citadel -> Dustwallow Marsh
  [515] = 15, -- Ironclad Prison -> Dustwallow Marsh
  [516] = 15, -- Dustwallow Bay -> Dustwallow Marsh
  [517] = 15, -- Tidefury Cove -> Dustwallow Marsh
  [518] = 15, -- Dreadmurk Shore -> Dustwallow Marsh
  [536] = 10, -- Addle's Stead -> Duskwood
  [537] = 490, -- Fire Plume Ridge -> Un'Goro Crater
  [538] = 490, -- Lakkari Tar Pits -> Un'Goro Crater
  [539] = 490, -- Terror Run -> Un'Goro Crater
  [540] = 490, -- The Slithering Scar -> Un'Goro Crater
  [541] = 490, -- Marshal's Refuge -> Un'Goro Crater
  [542] = 490, -- Fungal Rock -> Un'Goro Crater
  [543] = 490, -- Golakka Hot Springs -> Un'Goro Crater
  [556] = 38, -- The Loch -> Loch Modan
  [576] = 10, -- Beggar's Haunt -> Duskwood
  [596] = 405, -- Kodo Graveyard -> Desolace
  [597] = 405, -- Ghost Walker Post -> Desolace
  [598] = 405, -- Sar'theris Strand -> Desolace
  [599] = 405, -- Thunder Axe Fortress -> Desolace
  [600] = 405, -- Bolgan's Hole -> Desolace
  [602] = 405, -- Mannoroc Coven -> Desolace
  [603] = 405, -- Sargeron -> Desolace
  [604] = 405, -- Magram Village -> Desolace
  [606] = 405, -- Gelkis Village -> Desolace
  [607] = 405, -- Valley of Spears -> Desolace
  [608] = 405, -- Nijel's Point -> Desolace
  [609] = 405, -- Kolkar Village -> Desolace
  [636] = 406, -- Blackwolf River -> Stonetalon Mountains
  [637] = 215, -- Kodo Rock -> Mulgore
  [638] = 14, -- Hidden Path -> Durotar
  [639] = 14, -- Spirit Rock -> Durotar
  [640] = 14, -- Shrine of the Dormant Flame -> Durotar
  [656] = 493, -- Lake Elune'ara -> Moonglade
  [657] = 8, -- The Harborage -> Swamp of Sorrows
  [696] = 141, -- Craftsmen's Terrace UNUSED -> Teldrassil
  [697] = 141, -- Tradesmen's Terrace UNUSED -> Teldrassil
  [698] = 141, -- The Temple Gardens UNUSED -> Teldrassil
  [699] = 141, -- Temple of Elune UNUSED -> Teldrassil
  [700] = 141, -- Cenarion Enclave UNUSED -> Teldrassil
  [701] = 141, -- Warrior's Terrace UNUSED -> Teldrassil
  [702] = 141, -- Rut'theran Village -> Teldrassil
  [716] = 1, -- Ironband's Compound -> Dun Morogh
  [720] = 17, -- Fray Island -> The Barrens
  [736] = 141, -- Ban'ethil Hollow -> Teldrassil
  [797] = 12, -- Jerod's Landing -> Elwynn Forest
  [798] = 12, -- Ridgepoint Tower -> Elwynn Forest
  [799] = 10, -- The Darkened Bank -> Duskwood
  [800] = 1, -- Coldridge Pass -> Dun Morogh
  [801] = 1, -- Chill Breeze Valley -> Dun Morogh
  [802] = 1, -- Shimmer Ridge -> Dun Morogh
  [803] = 1, -- Amberstill Ranch -> Dun Morogh
  [804] = 1, -- The Tundrid Hills -> Dun Morogh
  [805] = 1, -- South Gate Pass -> Dun Morogh
  [806] = 1, -- South Gate Outpost -> Dun Morogh
  [807] = 1, -- North Gate Pass -> Dun Morogh
  [808] = 1, -- North Gate Outpost -> Dun Morogh
  [809] = 1, -- Gates of Ironforge -> Dun Morogh
  [810] = 85, -- Stillwater Pond -> Tirisfal Glades
  [811] = 85, -- Nightmare Vale -> Tirisfal Glades
  [812] = 85, -- Venomweb Vale -> Tirisfal Glades
  [813] = 28, -- The Bulwark -> Western Plaguelands
  [814] = 377, -- Southfury River -> Southfury River
  [815] = 377, -- Southfury River -> Southfury River
  [816] = 14, -- Razormane Grounds -> Durotar
  [817] = 14, -- Skull Rock -> Durotar
  [818] = 215, -- Palemane Rock -> Mulgore
  [819] = 215, -- Windfury Ridge -> Mulgore
  [820] = 215, -- The Golden Plains -> Mulgore
  [821] = 215, -- The Rolling Plains -> Mulgore
  [836] = 269, -- Dun Algaz -> Dun Algaz
  [837] = 269, -- Dun Algaz -> Dun Algaz
  [838] = 38, -- North Gate Pass -> Loch Modan
  [839] = 38, -- South Gate Pass -> Loch Modan
  [856] = 10, -- Twilight Grove -> Duskwood
  [877] = 17, -- Delete ME -> The Barrens
  [878] = 377, -- Southfury River -> Southfury River
  [879] = 377, -- Southfury River -> Southfury River
  [880] = 330, -- Thandol Span -> Thandol Span
  [881] = 330, -- Thandol Span -> Thandol Span
  [896] = 267, -- Purgation Isle -> Hillsbrad Foothills
  [916] = 40, -- The Jansen Stead -> Westfall
  [917] = 40, -- The Dead Acre -> Westfall
  [918] = 40, -- The Molsen Farm -> Westfall
  [919] = 40, -- Stendel's Pond -> Westfall
  [920] = 40, -- The Dagger Hills -> Westfall
  [921] = 40, -- Demont's Place -> Westfall
  [922] = 40, -- The Dust Plains -> Westfall
  [923] = 38, -- Stonesplinter Valley -> Loch Modan
  [924] = 38, -- Valley of Kings -> Loch Modan
  [925] = 38, -- Algaz Station -> Loch Modan
  [926] = 130, -- Bucklebree Farm -> Silverpine Forest
  [927] = 130, -- The Shining Strand -> Silverpine Forest
  [928] = 130, -- North Tide's Hollow -> Silverpine Forest
  [936] = 38, -- Grizzlepaw Ridge -> Loch Modan
  [976] = 440, -- Gadgetzan -> Tanaris
  [977] = 440, -- Steamwheedle Port -> Tanaris
  [978] = 1176, -- Zul'Farrak -> Zul'Farrak
  [979] = 440, -- Sandsorrow Watch -> Tanaris
  [980] = 440, -- Thistleshrub Valley -> Tanaris
  [981] = 440, -- The Gaping Chasm -> Tanaris
  [982] = 440, -- The Noxious Lair -> Tanaris
  [983] = 440, -- Dunemaul Compound -> Tanaris
  [984] = 440, -- Eastmoon Ruins -> Tanaris
  [985] = 440, -- Waterspring Field -> Tanaris
  [986] = 440, -- Zalashji's Den -> Tanaris
  [987] = 440, -- Land's End Beach -> Tanaris
  [988] = 440, -- Wavestrider Beach -> Tanaris
  [989] = 440, -- Uldum -> Tanaris
  [990] = 440, -- Valley of the Watchers -> Tanaris
  [991] = 440, -- Gunstan's Post -> Tanaris
  [992] = 440, -- Southmoon Ruins -> Tanaris
  [996] = 44, -- Render's Camp -> Redridge Mountains
  [997] = 44, -- Render's Valley -> Redridge Mountains
  [998] = 44, -- Render's Rock -> Redridge Mountains
  [999] = 44, -- Stonewatch Tower -> Redridge Mountains
  [1000] = 44, -- Galardell Valley -> Redridge Mountains
  [1001] = 44, -- Lakeridge Highway -> Redridge Mountains
  [1002] = 44, -- Three Corners -> Redridge Mountains
  [1016] = 11, -- Direforge Hill -> Wetlands
  [1017] = 11, -- Raptor Ridge -> Wetlands
  [1018] = 11, -- Black Channel Marsh -> Wetlands
  [1019] = 139, -- The Green Belt -> Eastern Plaguelands
  [1020] = 11, -- Mosshide Fen -> Wetlands
  [1021] = 11, -- Thelgen Rock -> Wetlands
  [1022] = 11, -- Bluegill Marsh -> Wetlands
  [1023] = 11, -- Saltspray Glen -> Wetlands
  [1024] = 11, -- Sundown Marsh -> Wetlands
  [1025] = 11, -- The Green Belt -> Wetlands
  [1036] = 11, -- Angerfang Encampment -> Wetlands
  [1037] = 11, -- Grim Batol -> Wetlands
  [1038] = 11, -- Dragonmaw Gates -> Wetlands
  [1039] = 11, -- The Lost Fleet -> Wetlands
  [1056] = 267, -- Darrow Hill -> Hillsbrad Foothills
  [1057] = 293, -- Thoradin's Wall -> Thoradin's Wall
  [1076] = 406, -- Webwinder Path -> Stonetalon Mountains
  [1097] = 10, -- The Hushed Bank -> Duskwood
  [1098] = 10, -- Manor Mistmantle -> Duskwood
  [1099] = 357, -- Camp Mojache -> Feralas
  [1100] = 357, -- Grimtotem Compound -> Feralas
  [1101] = 357, -- The Writhing Deep -> Feralas
  [1102] = 357, -- Wildwind Lake -> Feralas
  [1103] = 357, -- Gordunni Outpost -> Feralas
  [1104] = 357, -- Mok'Gordun -> Feralas
  [1105] = 357, -- Feral Scar Vale -> Feralas
  [1106] = 357, -- Frayfeather Highlands -> Feralas
  [1107] = 357, -- Idlewind Lake -> Feralas
  [1108] = 357, -- The Forgotten Coast -> Feralas
  [1109] = 357, -- East Pillar -> Feralas
  [1110] = 357, -- West Pillar -> Feralas
  [1111] = 357, -- Dream Bough -> Feralas
  [1112] = 357, -- Jademir Lake -> Feralas
  [1113] = 357, -- Oneiros -> Feralas
  [1114] = 357, -- Ruins of Ravenwind -> Feralas
  [1115] = 357, -- Rage Scar Hold -> Feralas
  [1116] = 357, -- Feathermoon Stronghold -> Feralas
  [1117] = 357, -- Ruins of Solarsal -> Feralas
  [1118] = 357, -- Lower Wilds UNUSED -> Feralas
  [1119] = 357, -- The Twin Colossals -> Feralas
  [1120] = 357, -- Sardor Isle -> Feralas
  [1121] = 357, -- Isle of Dread -> Feralas
  [1136] = 357, -- High Wilderness -> Feralas
  [1137] = 357, -- Lower Wilds -> Feralas
  [1156] = 17, -- Southern Barrens -> The Barrens
  [1157] = 17, -- Southern Gold Road -> The Barrens
  [1216] = 16, -- Timbermaw Hold -> Azshara
  [1217] = 16, -- Vanndir Encampment -> Azshara
  [1218] = 16, -- TESTAzshara -> Azshara
  [1219] = 16, -- Legash Encampment -> Azshara
  [1220] = 16, -- Thalassian Base Camp -> Azshara
  [1221] = 16, -- Ruins of Eldarath -> Azshara
  [1222] = 16, -- Hetaera's Clutch -> Azshara
  [1223] = 16, -- Temple of Zin-Malor -> Azshara
  [1224] = 16, -- Bear's Head -> Azshara
  [1225] = 16, -- Ursolan -> Azshara
  [1226] = 16, -- Temple of Arkkoran -> Azshara
  [1227] = 16, -- Bay of Storms -> Azshara
  [1228] = 16, -- The Shattered Strand -> Azshara
  [1229] = 16, -- Tower of Eldara -> Azshara
  [1230] = 16, -- Jagged Reef -> Azshara
  [1231] = 16, -- Southridge Beach -> Azshara
  [1232] = 16, -- Ravencrest Monument -> Azshara
  [1233] = 16, -- Forlorn Ridge -> Azshara
  [1234] = 16, -- Lake Mennar -> Azshara
  [1235] = 16, -- Shadowsong Shrine -> Azshara
  [1236] = 16, -- Haldarr Encampment -> Azshara
  [1237] = 16, -- Valormok -> Azshara
  [1256] = 16, -- The Ruined Reaches -> Azshara
  [1276] = 331, -- The Talondeep Path -> Ashenvale
  [1277] = 406, -- The Talondeep Path -> Stonetalon Mountains
  [1296] = 14, -- Rocktusk Farm -> Durotar
  [1297] = 14, -- Jaggedswine Farm -> Durotar
  [1316] = 722, -- Razorfen Downs -> Razorfen Downs
  [1336] = 440, -- Lost Rigger Cove -> Tanaris
  [1338] = 170, -- Lordamere Lake -> Lordamere Lake
  [1339] = 170, -- Lordamere Lake -> Lordamere Lake
  [1357] = 36, -- Gallows' Corner -> Alterac Mountains
  [1437] = 4, -- Dreadmaul Hold -> Blasted Lands
  [1438] = 4, -- Nethergarde Keep -> Blasted Lands
  [1439] = 4, -- Dreadmaul Post -> Blasted Lands
  [1440] = 4, -- Serpent's Coil -> Blasted Lands
  [1441] = 4, -- Altar of Storms -> Blasted Lands
  [1442] = 51, -- Firewatch Ridge -> Searing Gorge
  [1443] = 51, -- The Slag Pit -> Searing Gorge
  [1444] = 51, -- The Sea of Cinders -> Searing Gorge
  [1445] = 25, -- Blackrock Mountain -> Blackrock Mountain
  [1446] = 51, -- Thorium Point -> Searing Gorge
  [1457] = 4, -- Garrison Armory -> Blasted Lands
  [1517] = 1337, -- Uldaman -> Uldaman
  [1518] = 40, -- Not Used Deadmines -> Westfall
  [1557] = 400, -- Splithoof Hold -> Thousand Needles
  [1577] = 33, -- The Cape of Stranglethorn -> Stranglethorn Vale
  [1578] = 33, -- Southern Savage Coast -> Stranglethorn Vale
  [1580] = 1579, -- Unused Ironclad Cove 003 -> Unused The Deadmines 002
  [1582] = 1581, -- Ironclad Cove -> The Deadmines
  [1597] = 17, -- Raptor Grounds UNUSED -> The Barrens
  [1598] = 17, -- Grol'dom Farm UNUSED -> The Barrens
  [1599] = 17, -- Mor'shan Base Camp -> The Barrens
  [1600] = 17, -- Honor's Stand UNUSED -> The Barrens
  [1601] = 17, -- Blackthorn Ridge UNUSED -> The Barrens
  [1602] = 17, -- Bramblescar UNUSED -> The Barrens
  [1603] = 17, -- Agama'gor UNUSED -> The Barrens
  [1617] = 1519, -- Valley of Heroes -> Stormwind City
  [1639] = 1638, -- Elder Rise -> Thunder Bluff
  [1640] = 1638, -- Spirit Rise -> Thunder Bluff
  [1641] = 1638, -- Hunter Rise -> Thunder Bluff
  [1658] = 1657, -- Cenarion Enclave -> Darnassus
  [1659] = 1657, -- Craftsmen's Terrace -> Darnassus
  [1660] = 1657, -- Warrior's Terrace -> Darnassus
  [1661] = 1657, -- The Temple Gardens -> Darnassus
  [1662] = 1657, -- Tradesmen's Terrace -> Darnassus
  [1677] = 36, -- Gavin's Naze -> Alterac Mountains
  [1678] = 36, -- Sofera's Naze -> Alterac Mountains
  [1679] = 36, -- Corrahn's Dagger -> Alterac Mountains
  [1680] = 36, -- The Headland -> Alterac Mountains
  [1681] = 36, -- Misty Shore -> Alterac Mountains
  [1682] = 36, -- Dandred's Fold -> Alterac Mountains
  [1683] = 36, -- Growless Cave -> Alterac Mountains
  [1684] = 36, -- Chillwind Point -> Alterac Mountains
  [1697] = 17, -- Raptor Grounds -> The Barrens
  [1698] = 17, -- Bramblescar -> The Barrens
  [1699] = 17, -- Thorn Hill -> The Barrens
  [1700] = 17, -- Agama'gor -> The Barrens
  [1701] = 17, -- Blackthorn Ridge -> The Barrens
  [1702] = 17, -- Honor's Stand -> The Barrens
  [1703] = 17, -- The Mor'shan Rampart -> The Barrens
  [1704] = 17, -- Grol'dom Farm -> The Barrens
  [1717] = 491, -- Razorfen Kraul -> Razorfen Kraul
  [1718] = 17, -- The Great Lift -> The Barrens
  [1737] = 33, -- Mistvale Valley -> Stranglethorn Vale
  [1738] = 33, -- Nek'mani Wellspring -> Stranglethorn Vale
  [1739] = 33, -- Bloodsail Compound -> Stranglethorn Vale
  [1740] = 33, -- Venture Co. Base Camp -> Stranglethorn Vale
  [1741] = 33, -- Gurubashi Arena -> Stranglethorn Vale
  [1742] = 33, -- Spirit Den -> Stranglethorn Vale
  [1757] = 33, -- The Crimson Veil -> Stranglethorn Vale
  [1758] = 33, -- The Riptide -> Stranglethorn Vale
  [1759] = 33, -- The Damsel's Luck -> Stranglethorn Vale
  [1760] = 33, -- Venture Co. Operations Center -> Stranglethorn Vale
  [1761] = 361, -- Deadwood Village -> Felwood
  [1762] = 361, -- Felpaw Village -> Felwood
  [1763] = 361, -- Jaedenar -> Felwood
  [1764] = 361, -- Bloodvenom River -> Felwood
  [1765] = 361, -- Bloodvenom Falls -> Felwood
  [1766] = 361, -- Shatter Scar Vale -> Felwood
  [1767] = 361, -- Irontree Woods -> Felwood
  [1768] = 361, -- Irontree Cavern -> Felwood
  [1769] = 361, -- Timbermaw Hold -> Felwood
  [1770] = 361, -- Shadow Hold -> Felwood
  [1771] = 361, -- Shrine of the Deceiver -> Felwood
  [1777] = 8, -- Itharius's Cave -> Swamp of Sorrows
  [1778] = 8, -- Sorrowmurk -> Swamp of Sorrows
  [1779] = 8, -- Draenil'dur Village -> Swamp of Sorrows
  [1780] = 8, -- Splinterspear Junction -> Swamp of Sorrows
  [1797] = 8, -- Stagalbog -> Swamp of Sorrows
  [1798] = 8, -- The Shifting Mire -> Swamp of Sorrows
  [1817] = 8, -- Stagalbog Cave -> Swamp of Sorrows
  [1837] = 45, -- Witherbark Caverns -> Arathi Highlands
  [1857] = 293, -- Thoradin's Wall -> Thoradin's Wall
  [1858] = 45, -- Boulder'gor -> Arathi Highlands
  [1877] = 3, -- Valley of Fangs -> Badlands
  [1878] = 3, -- The Dustbowl -> Badlands
  [1879] = 3, -- Mirage Flats -> Badlands
  [1880] = 47, -- Featherbeard's Hovel -> The Hinterlands
  [1881] = 47, -- Shindigger's Camp -> The Hinterlands
  [1882] = 47, -- Plaguemist Ravine -> The Hinterlands
  [1883] = 47, -- Valorwind Lake -> The Hinterlands
  [1884] = 47, -- Agol'watha -> The Hinterlands
  [1885] = 47, -- Hiri'watha -> The Hinterlands
  [1886] = 47, -- The Creeping Ruin -> The Hinterlands
  [1887] = 47, -- Bogen's Ledge -> The Hinterlands
  [1897] = 3, -- The Maker's Terrace -> Badlands
  [1898] = 3, -- Dustwind Gulch -> Badlands
  [1917] = 47, -- Shaol'watha -> The Hinterlands
  [1937] = 440, -- Noonshade Ruins -> Tanaris
  [1938] = 440, -- Broken Pillar -> Tanaris
  [1939] = 440, -- Abyssal Sands -> Tanaris
  [1940] = 440, -- Southbreak Shore -> Tanaris
  [1942] = 490, -- The Marshlands -> Un'Goro Crater
  [1943] = 490, -- Ironstone Plateau -> Un'Goro Crater
  [1957] = 51, -- Blackchar Cave -> Searing Gorge
  [1958] = 51, -- Tanner Camp -> Searing Gorge
  [1959] = 51, -- Dustfire Valley -> Searing Gorge
  [1978] = 8, -- Misty Reed Post -> Swamp of Sorrows
  [1997] = 361, -- Bloodvenom Post  -> Felwood
  [1998] = 361, -- Talonbranch Glade  -> Felwood
  [2077] = 148, -- Twilight Vale -> Darkshore
  [2078] = 148, -- Twilight Shore -> Darkshore
  [2079] = 15, -- Alcaz Island -> Dustwallow Marsh
  [2097] = 400, -- Darkcloud Pinnacle -> Thousand Needles
  [2098] = 10, -- Dawning Wood Catacombs -> Duskwood
  [2099] = 44, -- Stonewatch Keep -> Redridge Mountains
  [2101] = 38, -- Stoutlager Inn -> Loch Modan
  [2102] = 1, -- Thunderbrew Distillery -> Dun Morogh
  [2103] = 11, -- Menethil Keep -> Wetlands
  [2104] = 11, -- Deepwater Tavern -> Wetlands
  [2117] = 85, -- Shadow Grave -> Tirisfal Glades
  [2118] = 85, -- Brill Town Hall -> Tirisfal Glades
  [2119] = 85, -- Gallows' End Tavern -> Tirisfal Glades
  [2137] = 215, -- The Pools of VisionUNUSED -> Mulgore
  [2138] = 17, -- Dreadmist Den -> The Barrens
  [2157] = 17, -- Bael'dun Keep -> The Barrens
  [2158] = 15, -- Emberstrife's Den -> Dustwallow Marsh
  [2160] = 406, -- Windshear Mine -> Stonetalon Mountains
  [2161] = 10, -- Roland's Doom -> Duskwood
  [2177] = 33, -- Battle Ring -> Stranglethorn Vale
  [2197] = 1638, -- The Pools of Vision -> Thunder Bluff
  [2198] = 405, -- Shadowbreak Ravine -> Desolace
  [2217] = 405, -- Broken Spear Village -> Desolace
  [2237] = 400, -- Whitereach Post -> Thousand Needles
  [2238] = 400, -- Gornia -> Thousand Needles
  [2239] = 400, -- Zane's Eye Crater -> Thousand Needles
  [2240] = 400, -- Mirage Raceway -> Thousand Needles
  [2241] = 618, -- Frostsaber Rock -> Winterspring
  [2242] = 618, -- The Hidden Grove -> Winterspring
  [2243] = 618, -- Timbermaw Post -> Winterspring
  [2244] = 618, -- Winterfall Village -> Winterspring
  [2245] = 618, -- Mazthoril -> Winterspring
  [2246] = 618, -- Frostfire Hot Springs -> Winterspring
  [2247] = 618, -- Ice Thistle Hills -> Winterspring
  [2248] = 618, -- Dun Mandarr -> Winterspring
  [2249] = 618, -- Frostwhisper Gorge -> Winterspring
  [2250] = 618, -- Owl Wing Thicket -> Winterspring
  [2251] = 618, -- Lake Kel'Theril -> Winterspring
  [2252] = 618, -- The Ruins of Kel'Theril -> Winterspring
  [2253] = 618, -- Starfall Village -> Winterspring
  [2254] = 618, -- Ban'Thallow Barrow Den -> Winterspring
  [2255] = 618, -- Everlook -> Winterspring
  [2256] = 618, -- Darkwhisper Gorge -> Winterspring
  [2258] = 139, -- The Fungal Vale -> Eastern Plaguelands
  [2259] = 139, -- UNUSEDThe Marris Stead -> Eastern Plaguelands
  [2260] = 139, -- The Marris Stead -> Eastern Plaguelands
  [2261] = 139, -- The Undercroft -> Eastern Plaguelands
  [2262] = 139, -- Darrowshire -> Eastern Plaguelands
  [2263] = 139, -- Crown Guard Tower -> Eastern Plaguelands
  [2264] = 139, -- Corin's Crossing -> Eastern Plaguelands
  [2265] = 139, -- Scarlet Base Camp -> Eastern Plaguelands
  [2266] = 139, -- Tyr's Hand -> Eastern Plaguelands
  [2267] = 139, -- The Scarlet Basilica -> Eastern Plaguelands
  [2268] = 139, -- Light's Hope Chapel -> Eastern Plaguelands
  [2269] = 139, -- Browman Mill -> Eastern Plaguelands
  [2270] = 139, -- The Noxious Glade -> Eastern Plaguelands
  [2271] = 139, -- Eastwall Tower -> Eastern Plaguelands
  [2272] = 139, -- Northdale -> Eastern Plaguelands
  [2273] = 139, -- Zul'Mashar -> Eastern Plaguelands
  [2274] = 139, -- Mazra'Alor -> Eastern Plaguelands
  [2275] = 139, -- Northpass Tower -> Eastern Plaguelands
  [2276] = 139, -- Quel'Lithien Lodge -> Eastern Plaguelands
  [2277] = 139, -- Plaguewood -> Eastern Plaguelands
  [2278] = 139, -- Scourgehold -> Eastern Plaguelands
  [2279] = 2017, -- Stratholme -> Stratholme
  [2297] = 28, -- Darrowmere Lake -> Western Plaguelands
  [2298] = 28, -- Caer Darrow -> Western Plaguelands
  [2299] = 139, -- Darrowmere Lake -> Eastern Plaguelands
  [2300] = 1941, -- Caverns of Time -> Caverns of Time
  [2301] = 331, -- Thistlefur Village -> Ashenvale
  [2302] = 15, -- The Quagmire -> Dustwallow Marsh
  [2303] = 400, -- Windbreak Canyon -> Thousand Needles
  [2317] = 440, -- South Seas -> Tanaris
  [2318] = 207, -- The Great Sea -> The Great Sea
  [2319] = 207, -- The Great Sea -> The Great Sea
  [2320] = 207, -- The Great Sea -> The Great Sea
  [2321] = 207, -- The Great Sea -> The Great Sea
  [2322] = 457, -- The Veiled Sea -> The Veiled Sea
  [2323] = 457, -- The Veiled Sea -> The Veiled Sea
  [2324] = 457, -- The Veiled Sea -> The Veiled Sea
  [2325] = 457, -- The Veiled Sea -> The Veiled Sea
  [2326] = 457, -- The Veiled Sea -> The Veiled Sea
  [2337] = 14, -- Razor Hill Barracks -> Durotar
  [2338] = 33, -- South Seas -> Stranglethorn Vale
  [2339] = 207, -- The Great Sea -> The Great Sea
  [2357] = 331, -- Bloodtooth Camp -> Ashenvale
  [2358] = 331, -- Forest Song -> Ashenvale
  [2359] = 331, -- Greenpaw Village -> Ashenvale
  [2360] = 331, -- Silverwing Outpost -> Ashenvale
  [2361] = 493, -- Nighthaven -> Moonglade
  [2362] = 493, -- Shrine of Remulos -> Moonglade
  [2363] = 493, -- Stormrage Barrow Dens -> Moonglade
  [2364] = 207, -- The Great Sea -> The Great Sea
  [2365] = 207, -- The Great Sea -> The Great Sea
  [2368] = 2367, -- Tarren Mill -> Old Hillsbrad Foothills
  [2369] = 2367, -- Southshore -> Old Hillsbrad Foothills
  [2370] = 2367, -- Durnholde Keep -> Old Hillsbrad Foothills
  [2371] = 2367, -- Dun Garok -> Old Hillsbrad Foothills
  [2372] = 2367, -- Hillsbrad Fields -> Old Hillsbrad Foothills
  [2373] = 2367, -- Eastern Strand -> Old Hillsbrad Foothills
  [2374] = 2367, -- Nethander Stead -> Old Hillsbrad Foothills
  [2375] = 2367, -- Darrow Hill -> Old Hillsbrad Foothills
  [2376] = 2367, -- Southpoint Tower -> Old Hillsbrad Foothills
  [2377] = 293, -- Thoradin's Wall -> Thoradin's Wall
  [2378] = 2367, -- Western Strand -> Old Hillsbrad Foothills
  [2379] = 2367, -- Azurelode Mine -> Old Hillsbrad Foothills
  [2397] = 207, -- The Great Sea -> The Great Sea
  [2398] = 207, -- The Great Sea -> The Great Sea
  [2399] = 207, -- The Great Sea -> The Great Sea
  [2400] = 308, -- The Forbidding Sea -> The Forbidding Sea
  [2401] = 308, -- The Forbidding Sea -> The Forbidding Sea
  [2402] = 308, -- The Forbidding Sea -> The Forbidding Sea
  [2403] = 308, -- The Forbidding Sea -> The Forbidding Sea
  [2404] = 405, -- Tethris Aran -> Desolace
  [2405] = 405, -- Ethel Rethor -> Desolace
  [2406] = 405, -- Ranazjar Isle -> Desolace
  [2407] = 405, -- Kormek's Hut -> Desolace
  [2408] = 405, -- Shadowprey Village -> Desolace
  [2417] = 46, -- Blackrock Pass -> Burning Steppes
  [2418] = 46, -- Morgan's Vigil -> Burning Steppes
  [2419] = 46, -- Slither Rock -> Burning Steppes
  [2420] = 46, -- Terror Wing Path -> Burning Steppes
  [2421] = 46, -- Draco'dar -> Burning Steppes
  [2457] = 331, -- Nightsong Woods -> Ashenvale
  [2477] = 457, -- The Veiled Sea -> The Veiled Sea
  [2478] = 361, -- Morlos'Aran -> Felwood
  [2479] = 361, -- Emerald Sanctuary -> Felwood
  [2480] = 361, -- Jadefire Glen -> Felwood
  [2481] = 361, -- Ruins of Constellas -> Felwood
  [2497] = 16, -- Bitter Reaches -> Azshara
  [2517] = 4, -- Rise of the Defiler -> Blasted Lands
  [2518] = 357, -- Lariss Pavilion -> Feralas
  [2519] = 357, -- Woodpaw Hills -> Feralas
  [2520] = 357, -- Woodpaw Den -> Feralas
  [2521] = 357, -- Verdantis River -> Feralas
  [2522] = 357, -- Ruins of Isildien -> Feralas
  [2537] = 406, -- Grimtotem Post -> Stonetalon Mountains
  [2538] = 406, -- Camp Aparaje -> Stonetalon Mountains
  [2539] = 406, -- Malaka'jin -> Stonetalon Mountains
  [2540] = 406, -- Boulderslide Ravine -> Stonetalon Mountains
  [2541] = 406, -- Sishir Canyon -> Stonetalon Mountains
  [2558] = 41, -- Deadwind Ravine -> Deadwind Pass
  [2559] = 41, -- Diamondhead River -> Deadwind Pass
  [2560] = 41, -- Ariden's Camp -> Deadwind Pass
  [2561] = 41, -- The Vice -> Deadwind Pass
  [2562] = 3457, -- Karazhan -> Karazhan
  [2563] = 41, -- Morgan's Plot -> Deadwind Pass
  [2577] = 2557, -- Dire Maul -> Dire Maul
  [2617] = 405, -- Scrabblescrew's Camp -> Desolace
  [2618] = 361, -- Jadefire Run -> Felwood
  [2619] = 139, -- Thondroril River -> Eastern Plaguelands
  [2620] = 28, -- Thondroril River -> Western Plaguelands
  [2621] = 139, -- Lake Mereldar -> Eastern Plaguelands
  [2622] = 139, -- Pestilent Scar -> Eastern Plaguelands
  [2623] = 139, -- The Infectis Scar -> Eastern Plaguelands
  [2624] = 139, -- Blackwood Lake -> Eastern Plaguelands
  [2625] = 139, -- Eastwall Gate -> Eastern Plaguelands
  [2626] = 139, -- Terrorweb Tunnel -> Eastern Plaguelands
  [2627] = 139, -- Terrordale -> Eastern Plaguelands
  [2637] = 331, -- Kargathia Keep -> Ashenvale
  [2657] = 405, -- Valley of Bones -> Desolace
  [2697] = 41, -- Deadman's Crossing -> Deadwind Pass
  [2737] = 1377, -- The Scarab Wall -> Silithus
  [2738] = 1377, -- Southwind Village -> Silithus
  [2739] = 1377, -- Twilight Base Camp -> Silithus
  [2740] = 1377, -- The Crystal Vale -> Silithus
  [2741] = 1377, -- The Scarab Dais -> Silithus
  [2742] = 1377, -- Hive'Ashi -> Silithus
  [2743] = 1377, -- Hive'Zora -> Silithus
  [2744] = 1377, -- Hive'Regal -> Silithus
  [2757] = 17, -- Shrine of the Fallen Warrior -> The Barrens
  [2777] = 2597, -- UNUSED Alterac Valley -> Alterac Valley
  [2797] = 719, -- Blackfathom Deeps -> Blackfathom Deeps
  [2837] = 41, -- The Master's Cellar -> Deadwind Pass
  [2838] = 276, -- Stonewrought Pass -> UNUSED Stonewrought Pass
  [2839] = 2597, -- Alterac Valley -> Alterac Valley
  [2857] = 440, -- The Rumble Cage -> Tanaris
  [2877] = 22, -- Chunk Test -> Programmer Isle
  [2897] = 331, -- Zoram'gar Outpost -> Ashenvale
  [2937] = 41, -- Grosh'gok Compound -> Deadwind Pass
  [2938] = 41, -- Sleeping Gorge -> Deadwind Pass
  [2957] = 2597, -- Irondeep Mine -> Alterac Valley
  [2958] = 2597, -- Stonehearth Outpost -> Alterac Valley
  [2959] = 2597, -- Dun Baldar -> Alterac Valley
  [2960] = 2597, -- Icewing Pass -> Alterac Valley
  [2961] = 2597, -- Frostwolf Village -> Alterac Valley
  [2962] = 2597, -- Tower Point -> Alterac Valley
  [2963] = 2597, -- Coldtooth Mine -> Alterac Valley
  [2964] = 2597, -- Winterax Hold -> Alterac Valley
  [2977] = 2597, -- Iceblood Garrison -> Alterac Valley
  [2978] = 2597, -- Frostwolf Keep -> Alterac Valley
  [2979] = 14, -- Tor'kren Farm -> Durotar
  [3017] = 2597, -- Frost Dagger Pass -> Alterac Valley
  [3037] = 400, -- Ironstone Camp -> Thousand Needles
  [3038] = 400, -- Weazel's Crater -> Thousand Needles
  [3039] = 400, -- Tahonda Ruins -> Thousand Needles
  [3057] = 2597, -- Field of Strife -> Alterac Valley
  [3058] = 2597, -- Icewing Cavern -> Alterac Valley
  [3077] = 1377, -- Valor's Rest -> Silithus
  [3097] = 1377, -- The Swarming Pillar -> Silithus
  [3098] = 1377, -- Twilight Post -> Silithus
  [3099] = 1377, -- Twilight Outpost -> Silithus
  [3100] = 1377, -- Ravaged Twilight Camp -> Silithus
  [3117] = 357, -- Shalzaru's Lair -> Feralas
  [3137] = 16, -- Talrendis Point -> Azshara
  [3138] = 16, -- Rethress Sanctum -> Azshara
  [3139] = 618, -- Moon Horror Den -> Winterspring
  [3140] = 16, -- Scalebeard's Cave -> Azshara
  [3157] = 406, -- Boulderslide Cavern -> Stonetalon Mountains
  [3177] = 331, -- Warsong Labor Camp -> Ashenvale
  [3197] = 28, -- Chillwind Camp -> Western Plaguelands
  [3217] = 2557, -- The Maul -> Dire Maul
  [3237] = 2557, -- The Maul UNUSED -> Dire Maul
  [3257] = 1377, -- Bones of Grakkarond -> Silithus
  [3297] = 2597, -- Frostwolf Graveyard -> Alterac Valley
  [3298] = 2597, -- Frostwolf Pass -> Alterac Valley
  [3299] = 2597, -- Dun Baldar Pass -> Alterac Valley
  [3300] = 2597, -- Iceblood Graveyard -> Alterac Valley
  [3301] = 2597, -- Snowfall Graveyard -> Alterac Valley
  [3302] = 2597, -- Stonehearth Graveyard -> Alterac Valley
  [3303] = 2597, -- Stormpike Graveyard -> Alterac Valley
  [3304] = 2597, -- Icewing Bunker -> Alterac Valley
  [3305] = 2597, -- Stonehearth Bunker -> Alterac Valley
  [3306] = 2597, -- Wildpaw Ridge -> Alterac Valley
  [3317] = 47, -- Revantusk Village -> The Hinterlands
  [3318] = 2597, -- Rock of Durotan -> Alterac Valley
  [3319] = 331, -- Silverwing Grove -> Ashenvale
  [3320] = 3277, -- Warsong Lumber Mill -> Warsong Gulch
  [3321] = 3277, -- Silverwing Hold -> Warsong Gulch
  [3337] = 2597, -- Wildpaw Cavern -> Alterac Valley
  [3338] = 2597, -- The Veiled Cleft -> Alterac Valley
  [3357] = 33, -- Yojamba Isle -> Stranglethorn Vale
  [3377] = 1977, -- The Coil -> Zul'Gurub
  [3378] = 1977, -- Altar of Hir'eek -> Zul'Gurub
  [3379] = 1977, -- Shadra'zaar -> Zul'Gurub
  [3380] = 1977, -- Hakkari Grounds -> Zul'Gurub
  [3381] = 1977, -- Naze of Shirvallah -> Zul'Gurub
  [3382] = 1977, -- Temple of Bethekk -> Zul'Gurub
  [3383] = 1977, -- The Bloodfire Pit -> Zul'Gurub
  [3384] = 1977, -- Altar of the Blood God -> Zul'Gurub
  [3397] = 1977, -- Zanza's Rise -> Zul'Gurub
  [3398] = 1977, -- Edge of Madness -> Zul'Gurub
  [3417] = 3358, -- Trollbane Hall -> Arathi Basin
  [3418] = 3358, -- Defiler's Den -> Arathi Basin
  [3419] = 1977, -- Pagle's Pointe -> Zul'Gurub
  [3420] = 3358, -- Farm -> Arathi Basin
  [3421] = 3358, -- Blacksmith -> Arathi Basin
  [3422] = 3358, -- Lumber Mill -> Arathi Basin
  [3423] = 3358, -- Gold Mine -> Arathi Basin
  [3424] = 3358, -- Stables -> Arathi Basin
  [3425] = 1377, -- Cenarion Hold -> Silithus
  [3426] = 1377, -- Staghelm Point -> Silithus
  [3427] = 1377, -- Bronzebeard Encampment -> Silithus
  [3431] = 3430, -- Sunstrider Isle -> Eversong Woods
  [3432] = 3430, -- Shrine of Dath'Remar -> Eversong Woods
  [3434] = 3428, -- Scarab Terrace -> Ahn'Qiraj
  [3435] = 3428, -- General's Terrace -> Ahn'Qiraj
  [3436] = 3428, -- The Reservoir -> Ahn'Qiraj
  [3437] = 3428, -- The Hatchery -> Ahn'Qiraj
  [3438] = 3428, -- The Comb -> Ahn'Qiraj
  [3439] = 3428, -- Watchers' Terrace -> Ahn'Qiraj
  [3440] = 3429, -- Scarab Terrace -> Ruins of Ahn'Qiraj
  [3441] = 3429, -- General's Terrace -> Ruins of Ahn'Qiraj
  [3442] = 3429, -- The Reservoir -> Ruins of Ahn'Qiraj
  [3443] = 3429, -- The Hatchery -> Ruins of Ahn'Qiraj
  [3444] = 3429, -- The Comb -> Ruins of Ahn'Qiraj
  [3445] = 3429, -- Watchers' Terrace -> Ruins of Ahn'Qiraj
  [3446] = 1377, -- Twilight's Run -> Silithus
  [3447] = 1377, -- Ortell's Hideout -> Silithus
  [3448] = 3429, -- Scarab Terrace -> Ruins of Ahn'Qiraj
  [3449] = 3429, -- General's Terrace -> Ruins of Ahn'Qiraj
  [3450] = 3429, -- The Reservoir -> Ruins of Ahn'Qiraj
  [3451] = 3429, -- The Hatchery -> Ruins of Ahn'Qiraj
  [3452] = 3429, -- The Comb -> Ruins of Ahn'Qiraj
  [3453] = 3429, -- Watchers' Terrace -> Ruins of Ahn'Qiraj
  [3454] = 1377, -- Ruins of Ahn'Qiraj -> Silithus
  [3460] = 3430, -- Golden Strand -> Eversong Woods
  [3461] = 3430, -- Sunsail Anchorage -> Eversong Woods
  [3462] = 3430, -- Fairbreeze Village -> Eversong Woods
  [3463] = 3430, -- Magisters Gate -> Eversong Woods
  [3464] = 3430, -- Farstrider Retreat -> Eversong Woods
  [3465] = 3430, -- North Sanctum -> Eversong Woods
  [3466] = 3430, -- West Sanctum -> Eversong Woods
  [3467] = 3430, -- East Sanctum -> Eversong Woods
  [3468] = 3430, -- Saltheril's Haven -> Eversong Woods
  [3469] = 3430, -- Thuron's Livery -> Eversong Woods
  [3470] = 3430, -- Stillwhisper Pond -> Eversong Woods
  [3471] = 3430, -- The Living Wood -> Eversong Woods
  [3472] = 3430, -- Azurebreeze Coast -> Eversong Woods
  [3473] = 3430, -- Lake Elrendar -> Eversong Woods
  [3474] = 3430, -- The Scorched Grove -> Eversong Woods
  [3475] = 3430, -- Zeb'Watha -> Eversong Woods
  [3476] = 3430, -- Tor'Watha -> Eversong Woods
  [3479] = 3524, -- The Veiled Sea -> Azuremyst Isle
  [3480] = 3430, -- Duskwither Grounds -> Eversong Woods
  [3481] = 3430, -- Duskwither Spire -> Eversong Woods
  [3482] = 3430, -- The Dead Scar -> Eversong Woods
  [3484] = 3430, -- The Sunspire -> Eversong Woods
  [3485] = 3430, -- Falthrien Academy -> Eversong Woods
  [3486] = 36, -- Ravenholdt Manor -> Alterac Mountains
  [3488] = 3433, -- Tranquillien -> Ghostlands
  [3489] = 3433, -- Suncrown Village -> Ghostlands
  [3490] = 3433, -- Goldenmist Village -> Ghostlands
  [3491] = 3433, -- Windrunner Village -> Ghostlands
  [3492] = 3433, -- Windrunner Spire -> Ghostlands
  [3493] = 3433, -- Sanctum of the Sun -> Ghostlands
  [3494] = 3433, -- Sanctum of the Moon -> Ghostlands
  [3495] = 3433, -- Dawnstar Spire -> Ghostlands
  [3496] = 3433, -- Farstrider Enclave -> Ghostlands
  [3497] = 3433, -- An'daroth -> Ghostlands
  [3498] = 3433, -- An'telas -> Ghostlands
  [3499] = 3433, -- An'owyn -> Ghostlands
  [3500] = 3433, -- Deatholme -> Ghostlands
  [3501] = 3433, -- Bleeding Ziggurat -> Ghostlands
  [3502] = 3433, -- Howling Ziggurat -> Ghostlands
  [3503] = 3433, -- Shalandis Isle -> Ghostlands
  [3504] = 3433, -- Toryl Estate -> Ghostlands
  [3505] = 3433, -- Underlight Mines -> Ghostlands
  [3506] = 3433, -- Andilien Estate -> Ghostlands
  [3507] = 3433, -- Hatchet Hills -> Ghostlands
  [3508] = 3433, -- Amani Pass -> Ghostlands
  [3509] = 3433, -- Sungraze Peak -> Ghostlands
  [3510] = 3433, -- Amani Catacombs -> Ghostlands
  [3511] = 3433, -- Tower of the Damned -> Ghostlands
  [3512] = 3433, -- Zeb'Sora -> Ghostlands
  [3513] = 3433, -- Lake Elrendar -> Ghostlands
  [3514] = 3433, -- The Dead Scar -> Ghostlands
  [3515] = 3433, -- Elrendar River -> Ghostlands
  [3516] = 3433, -- Zeb'Tela -> Ghostlands
  [3517] = 3433, -- Zeb'Nowa -> Ghostlands
  [3526] = 3524, -- Ammen Vale -> Azuremyst Isle
  [3527] = 3524, -- Crash Site -> Azuremyst Isle
  [3528] = 3524, -- Silverline Lake -> Azuremyst Isle
  [3529] = 3524, -- Nestlewood Thicket -> Azuremyst Isle
  [3530] = 3524, -- Shadow Ridge -> Azuremyst Isle
  [3531] = 3430, -- Skulking Row -> Eversong Woods
  [3532] = 3430, -- Dawning Lane -> Eversong Woods
  [3533] = 3430, -- Ruins of Silvermoon -> Eversong Woods
  [3534] = 3430, -- Feth's Way -> Eversong Woods
  [3536] = 3483, -- Thrallmar -> Hellfire Peninsula
  [3538] = 3483, -- Honor Hold -> Hellfire Peninsula
  [3539] = 3483, -- The Stair of Destiny -> Hellfire Peninsula
  [3541] = 3483, -- Forge Camp: Mageddon -> Hellfire Peninsula
  [3542] = 3483, -- The Path of Glory -> Hellfire Peninsula
  [3543] = 3483, -- The Great Fissure -> Hellfire Peninsula
  [3544] = 3483, -- Plain of Shards -> Hellfire Peninsula
  [3545] = 3535, -- Hellfire Citadel -> Hellfire Citadel
  [3546] = 3483, -- Expedition Armory -> Hellfire Peninsula
  [3547] = 3483, -- Throne of Kil'jaeden -> Hellfire Peninsula
  [3548] = 3483, -- Forge Camp: Rage -> Hellfire Peninsula
  [3549] = 3483, -- Invasion Point: Annihilator -> Hellfire Peninsula
  [3550] = 3483, -- Borune Ruins -> Hellfire Peninsula
  [3551] = 3483, -- Ruins of Sha'naar -> Hellfire Peninsula
  [3552] = 3483, -- Temple of Telhamat -> Hellfire Peninsula
  [3553] = 3483, -- Pools of Aggonar -> Hellfire Peninsula
  [3554] = 3483, -- Falcon Watch -> Hellfire Peninsula
  [3555] = 3483, -- Mag'har Post -> Hellfire Peninsula
  [3556] = 3483, -- Den of Haal'esh -> Hellfire Peninsula
  [3558] = 3430, -- Elrendar Falls -> Eversong Woods
  [3559] = 3524, -- Nestlewood Hills -> Azuremyst Isle
  [3560] = 3524, -- Ammen Fields -> Azuremyst Isle
  [3561] = 3524, -- The Sacred Grove -> Azuremyst Isle
  [3563] = 3535, -- Hellfire Citadel -> Hellfire Citadel
  [3564] = 3524, -- Emberglade -> Azuremyst Isle
  [3565] = 3521, -- Cenarion Refuge -> Zangarmarsh
  [3566] = 3524, -- Moonwing Den -> Azuremyst Isle
  [3567] = 3524, -- Pod Cluster -> Azuremyst Isle
  [3568] = 3524, -- Pod Wreckage -> Azuremyst Isle
  [3569] = 3524, -- Tides' Hollow -> Azuremyst Isle
  [3570] = 3524, -- Wrathscale Point -> Azuremyst Isle
  [3571] = 3524, -- Bristlelimb Village -> Azuremyst Isle
  [3572] = 3524, -- Stillpine Hold -> Azuremyst Isle
  [3573] = 3524, -- Odesyus' Landing -> Azuremyst Isle
  [3574] = 3524, -- Valaar's Berth -> Azuremyst Isle
  [3575] = 3524, -- Silting Shore -> Azuremyst Isle
  [3576] = 3524, -- Azure Watch -> Azuremyst Isle
  [3577] = 3524, -- Geezle's Camp -> Azuremyst Isle
  [3578] = 3524, -- Menagerie Wreckage -> Azuremyst Isle
  [3579] = 3524, -- Traitor's Cove -> Azuremyst Isle
  [3580] = 3524, -- Wildwind Peak -> Azuremyst Isle
  [3581] = 3524, -- Wildwind Path -> Azuremyst Isle
  [3582] = 3483, -- Zeth'Gor -> Hellfire Peninsula
  [3583] = 3525, -- Beryl Coast -> Bloodmyst Isle
  [3584] = 3525, -- Blood Watch -> Bloodmyst Isle
  [3585] = 3525, -- Bladewood -> Bloodmyst Isle
  [3586] = 3525, -- The Vector Coil -> Bloodmyst Isle
  [3587] = 3525, -- The Warp Piston -> Bloodmyst Isle
  [3588] = 3525, -- The Cryo-Core -> Bloodmyst Isle
  [3589] = 3525, -- The Crimson Reach -> Bloodmyst Isle
  [3590] = 3525, -- Wrathscale Lair -> Bloodmyst Isle
  [3591] = 3525, -- Ruins of Loreth'Aran -> Bloodmyst Isle
  [3592] = 3525, -- Nazzivian -> Bloodmyst Isle
  [3593] = 3525, -- Axxarien -> Bloodmyst Isle
  [3594] = 3525, -- Blacksilt Shore -> Bloodmyst Isle
  [3595] = 3525, -- The Foul Pool -> Bloodmyst Isle
  [3596] = 3525, -- The Hidden Reef -> Bloodmyst Isle
  [3597] = 3525, -- Amberweb Pass -> Bloodmyst Isle
  [3598] = 3525, -- Wyrmscar Island -> Bloodmyst Isle
  [3599] = 3525, -- Talon Stand -> Bloodmyst Isle
  [3600] = 3525, -- Bristlelimb Enclave -> Bloodmyst Isle
  [3601] = 3525, -- Ragefeather Ridge -> Bloodmyst Isle
  [3602] = 3525, -- Kessel's Crossing -> Bloodmyst Isle
  [3603] = 3525, -- Tel'athion's Camp -> Bloodmyst Isle
  [3604] = 3525, -- The Bloodcursed Reef -> Bloodmyst Isle
  [3608] = 3525, -- Vindicator's Rest -> Bloodmyst Isle
  [3609] = 3518, -- Unused3 -> Nagrand
  [3610] = 3518, -- Burning Blade Ruins -> Nagrand
  [3611] = 3518, -- Clan Watch -> Nagrand
  [3612] = 3525, -- Bloodcurse Isle -> Bloodmyst Isle
  [3613] = 3518, -- Garadar -> Nagrand
  [3614] = 3518, -- Skysong Lake -> Nagrand
  [3615] = 3518, -- Throne of the Elements -> Nagrand
  [3616] = 3518, -- Laughing Skull Ruins -> Nagrand
  [3617] = 3518, -- Warmaul Hill -> Nagrand
  [3618] = 3518, -- Gruul's Lair -> Nagrand
  [3619] = 3518, -- Auren Ridge -> Nagrand
  [3620] = 3518, -- Auren Falls -> Nagrand
  [3621] = 3518, -- Lake Sunspring -> Nagrand
  [3622] = 3518, -- Sunspring Post -> Nagrand
  [3623] = 3518, -- Aeris Landing -> Nagrand
  [3624] = 3518, -- Forge Camp: Fear -> Nagrand
  [3625] = 3518, -- Forge Camp: Hate -> Nagrand
  [3626] = 3518, -- Telaar -> Nagrand
  [3627] = 3518, -- Northwind Cleft -> Nagrand
  [3628] = 3518, -- Halaa -> Nagrand
  [3629] = 3518, -- Southwind Cleft -> Nagrand
  [3630] = 3518, -- Oshu'gun -> Nagrand
  [3631] = 3518, -- Spirit Fields -> Nagrand
  [3632] = 3518, -- Shamanar -> Nagrand
  [3633] = 3518, -- Ancestral Grounds -> Nagrand
  [3634] = 3518, -- Windyreed Village -> Nagrand
  [3635] = 3518, -- Unused2 -> Nagrand
  [3636] = 3518, -- Elemental Plateau -> Nagrand
  [3637] = 3518, -- Kil'sorrow Fortress -> Nagrand
  [3638] = 3518, -- The Ring of Trials -> Nagrand
  [3639] = 3524, -- Silvermyst Isle -> Azuremyst Isle
  [3640] = 3521, -- Daggerfen Village -> Zangarmarsh
  [3641] = 3521, -- Umbrafen Village -> Zangarmarsh
  [3642] = 3521, -- Feralfen Village -> Zangarmarsh
  [3643] = 3521, -- Bloodscale Enclave -> Zangarmarsh
  [3644] = 3521, -- Telredor -> Zangarmarsh
  [3645] = 3521, -- Zabra'jin -> Zangarmarsh
  [3646] = 3521, -- Quagg Ridge -> Zangarmarsh
  [3647] = 3521, -- The Spawning Glen -> Zangarmarsh
  [3648] = 3521, -- The Dead Mire -> Zangarmarsh
  [3649] = 3521, -- Sporeggar -> Zangarmarsh
  [3650] = 3521, -- Ango'rosh Grounds -> Zangarmarsh
  [3651] = 3521, -- Ango'rosh Stronghold -> Zangarmarsh
  [3652] = 3521, -- Funggor Cavern -> Zangarmarsh
  [3653] = 3521, -- Serpent Lake -> Zangarmarsh
  [3654] = 3521, -- The Drain -> Zangarmarsh
  [3655] = 3521, -- Umbrafen Lake -> Zangarmarsh
  [3656] = 3521, -- Marshlight Lake -> Zangarmarsh
  [3657] = 3521, -- Portal Clearing -> Zangarmarsh
  [3658] = 3521, -- Sporewind Lake -> Zangarmarsh
  [3659] = 3521, -- The Lagoon -> Zangarmarsh
  [3660] = 3521, -- Blades' Run -> Zangarmarsh
  [3661] = 3521, -- Blade Tooth Canyon -> Zangarmarsh
  [3662] = 3430, -- Commons Hall -> Eversong Woods
  [3663] = 3430, -- Derelict Manor -> Eversong Woods
  [3664] = 3430, -- Huntress of the Sun -> Eversong Woods
  [3665] = 3430, -- Falconwing Square -> Eversong Woods
  [3666] = 3518, -- Halaani Basin -> Nagrand
  [3667] = 3521, -- Hewn Bog -> Zangarmarsh
  [3668] = 3521, -- Boha'mu Ruins -> Zangarmarsh
  [3669] = 3483, -- The Stadium -> Hellfire Peninsula
  [3670] = 3483, -- The Overlook -> Hellfire Peninsula
  [3671] = 3483, -- Broken Hill -> Hellfire Peninsula
  [3672] = 3518, -- Mag'hari Procession -> Nagrand
  [3673] = 3518, -- Nesingwary Safari -> Nagrand
  [3674] = 3519, -- Cenarion Thicket -> Terokkar Forest
  [3675] = 3519, -- Tuurem -> Terokkar Forest
  [3676] = 3519, -- Veil Shienor -> Terokkar Forest
  [3677] = 3519, -- Veil Skith -> Terokkar Forest
  [3678] = 3519, -- Veil Shalas -> Terokkar Forest
  [3679] = 3519, -- Skettis -> Terokkar Forest
  [3680] = 3519, -- Blackwind Valley -> Terokkar Forest
  [3681] = 3519, -- Firewing Point -> Terokkar Forest
  [3682] = 3519, -- Grangol'var Village -> Terokkar Forest
  [3683] = 3519, -- Stonebreaker Hold -> Terokkar Forest
  [3684] = 3519, -- Allerian Stronghold -> Terokkar Forest
  [3685] = 3519, -- Bonechewer Ruins -> Terokkar Forest
  [3686] = 3519, -- Veil Lithic -> Terokkar Forest
  [3687] = 3519, -- Olembas -> Terokkar Forest
  [3688] = 3917, -- Auchindoun -> Auchindoun
  [3689] = 3519, -- Veil Reskk -> Terokkar Forest
  [3690] = 3519, -- Blackwind Lake -> Terokkar Forest
  [3691] = 3519, -- Lake Ere'Noru -> Terokkar Forest
  [3692] = 3519, -- Lake Jorune -> Terokkar Forest
  [3693] = 3519, -- Skethyl Mountains -> Terokkar Forest
  [3694] = 3519, -- Misty Ridge -> Terokkar Forest
  [3695] = 3519, -- The Broken Hills -> Terokkar Forest
  [3696] = 3519, -- The Barrier Hills -> Terokkar Forest
  [3697] = 3519, -- The Bone Wastes -> Terokkar Forest
  [3699] = 3518, -- Laughing Skull Courtyard -> Nagrand
  [3700] = 3518, -- The Ring of Blood -> Nagrand
  [3701] = 3518, -- Arena Floor -> Nagrand
  [3704] = 3487, -- The Shepherd's Gate -> Silvermoon City
  [3705] = 3518, -- Telaari Basin -> Nagrand
  [3706] = 2366, -- The Dark Portal -> The Black Morass
  [3707] = 3606, -- Alliance Base -> Hyjal Summit
  [3708] = 3606, -- Horde Encampment -> Hyjal Summit
  [3709] = 3606, -- Night Elf Village -> Hyjal Summit
  [3710] = 3606, -- Nordrassil -> Hyjal Summit
  [3712] = 3523, -- Area 52 -> Netherstorm
  [3718] = 3521, -- Swamprat Post -> Zangarmarsh
  [3719] = 3519, -- Bleeding Hollow Ruins -> Terokkar Forest
  [3720] = 3521, -- Twin Spire Ruins -> Zangarmarsh
  [3721] = 3523, -- The Crumbling Waste -> Netherstorm
  [3722] = 3523, -- Manaforge Ara -> Netherstorm
  [3723] = 3523, -- Arklon Ruins -> Netherstorm
  [3724] = 3523, -- Cosmowrench -> Netherstorm
  [3725] = 3523, -- Ruins of Enkaat -> Netherstorm
  [3726] = 3523, -- Manaforge B'naar -> Netherstorm
  [3727] = 3523, -- The Scrap Field -> Netherstorm
  [3728] = 3523, -- The Vortex Fields -> Netherstorm
  [3729] = 3523, -- The Heap -> Netherstorm
  [3730] = 3523, -- Manaforge Coruu -> Netherstorm
  [3731] = 3523, -- The Tempest Rift -> Netherstorm
  [3732] = 3523, -- Kirin'Var Village -> Netherstorm
  [3733] = 3523, -- The Violet Tower -> Netherstorm
  [3734] = 3523, -- Manaforge Duro -> Netherstorm
  [3735] = 3523, -- Voidwind Plateau -> Netherstorm
  [3736] = 3523, -- Manaforge Ultris -> Netherstorm
  [3737] = 3523, -- Celestial Ridge -> Netherstorm
  [3738] = 3523, -- The Stormspire -> Netherstorm
  [3739] = 3523, -- Forge Base: Oblivion -> Netherstorm
  [3740] = 3523, -- Forge Base: Gehenna -> Netherstorm
  [3741] = 3523, -- Ruins of Farahlon -> Netherstorm
  [3742] = 3523, -- Socrethar's Seat -> Netherstorm
  [3743] = 3520, -- Legion Hold -> Shadowmoon Valley
  [3744] = 3520, -- Shadowmoon Village -> Shadowmoon Valley
  [3745] = 3520, -- Wildhammer Stronghold -> Shadowmoon Valley
  [3746] = 3520, -- The Hand of Gul'dan -> Shadowmoon Valley
  [3747] = 3520, -- The Fel Pits -> Shadowmoon Valley
  [3748] = 3520, -- The Deathforge -> Shadowmoon Valley
  [3749] = 3520, -- Coilskar Cistern -> Shadowmoon Valley
  [3750] = 3520, -- Coilskar Point -> Shadowmoon Valley
  [3751] = 3520, -- Sunfire Point -> Shadowmoon Valley
  [3752] = 3520, -- Illidari Point -> Shadowmoon Valley
  [3753] = 3520, -- Ruins of Baa'ri -> Shadowmoon Valley
  [3754] = 3520, -- Altar of Sha'tar -> Shadowmoon Valley
  [3755] = 3520, -- The Stair of Doom -> Shadowmoon Valley
  [3756] = 3520, -- Ruins of Karabor -> Shadowmoon Valley
  [3757] = 3520, -- Ata'mal Terrace -> Shadowmoon Valley
  [3758] = 3520, -- Netherwing Fields -> Shadowmoon Valley
  [3759] = 3520, -- Netherwing Ledge -> Shadowmoon Valley
  [3760] = 3518, -- The Barrier Hills -> Nagrand
  [3761] = 3518, -- The High Path -> Nagrand
  [3762] = 3518, -- Windyreed Pass -> Nagrand
  [3763] = 3518, -- Zangar Ridge -> Nagrand
  [3764] = 3518, -- The Twilight Ridge -> Nagrand
  [3765] = 3483, -- Razorthorn Trail -> Hellfire Peninsula
  [3766] = 3521, -- Orebor Harborage -> Zangarmarsh
  [3767] = 3522, -- Blades' Run -> Blade's Edge Mountains
  [3768] = 3522, -- Jagged Ridge -> Blade's Edge Mountains
  [3769] = 3522, -- Thunderlord Stronghold -> Blade's Edge Mountains
  [3770] = 3522, -- Blade Tooth Canyon -> Blade's Edge Mountains
  [3771] = 3522, -- The Living Grove -> Blade's Edge Mountains
  [3772] = 3522, -- Sylvanaar -> Blade's Edge Mountains
  [3773] = 3522, -- Bladespire Hold -> Blade's Edge Mountains
  [3774] = 3923, -- Gruul's Lair -> Gruul's Lair
  [3775] = 3522, -- Circle of Blood -> Blade's Edge Mountains
  [3776] = 3522, -- Bloodmaul Outpost -> Blade's Edge Mountains
  [3777] = 3522, -- Bloodmaul Camp -> Blade's Edge Mountains
  [3778] = 3522, -- Draenethyst Mine -> Blade's Edge Mountains
  [3779] = 3522, -- Trogma's Claim -> Blade's Edge Mountains
  [3780] = 3522, -- Blackwing Coven -> Blade's Edge Mountains
  [3781] = 3522, -- Grishnath -> Blade's Edge Mountains
  [3782] = 3522, -- Veil Lashh -> Blade's Edge Mountains
  [3783] = 3522, -- Veil Vekh -> Blade's Edge Mountains
  [3784] = 3522, -- Forge Camp: Terror -> Blade's Edge Mountains
  [3785] = 3522, -- Forge Camp: Wrath -> Blade's Edge Mountains
  [3786] = 3522, -- Ogri'la -> Blade's Edge Mountains
  [3787] = 3522, -- Forge Camp: Anger -> Blade's Edge Mountains
  [3788] = 3518, -- The Low Path -> Nagrand
  [3793] = 3483, -- Felspark Ravine -> Hellfire Peninsula
  [3794] = 3483, -- Valley of Bones -> Hellfire Peninsula
  [3795] = 3483, -- Sha'naari Wastes -> Hellfire Peninsula
  [3796] = 3483, -- The Warp Fields -> Hellfire Peninsula
  [3797] = 3483, -- Fallen Sky Ridge -> Hellfire Peninsula
  [3798] = 3483, -- Haal'eshi Gorge -> Hellfire Peninsula
  [3799] = 3483, -- Stonewall Canyon -> Hellfire Peninsula
  [3800] = 3483, -- Thornfang Hill -> Hellfire Peninsula
  [3801] = 3483, -- Mag'har Grounds -> Hellfire Peninsula
  [3802] = 3483, -- Void Ridge -> Hellfire Peninsula
  [3803] = 3483, -- The Abyssal Shelf -> Hellfire Peninsula
  [3804] = 3483, -- The Legion Front -> Hellfire Peninsula
  [3806] = 3483, -- Supply Caravan -> Hellfire Peninsula
  [3807] = 3483, -- Reaver's Fall -> Hellfire Peninsula
  [3808] = 3483, -- Cenarion Post -> Hellfire Peninsula
  [3809] = 3483, -- Southern Rampart -> Hellfire Peninsula
  [3810] = 3483, -- Northern Rampart -> Hellfire Peninsula
  [3811] = 3483, -- Gor'gaz Outpost -> Hellfire Peninsula
  [3812] = 3483, -- Spinebreaker Post -> Hellfire Peninsula
  [3813] = 3483, -- The Path of Anguish -> Hellfire Peninsula
  [3814] = 3483, -- East Supply Caravan -> Hellfire Peninsula
  [3815] = 3483, -- Expedition Point -> Hellfire Peninsula
  [3816] = 3483, -- Zeppelin Crash -> Hellfire Peninsula
  [3818] = 3521, -- Bloodscale Grounds -> Zangarmarsh
  [3819] = 3521, -- Darkcrest Enclave -> Zangarmarsh
  [3821] = 3520, -- Warden's Cage -> Shadowmoon Valley
  [3822] = 3520, -- Eclipse Point -> Shadowmoon Valley
  [3823] = 3433, -- Isle of Tribulations -> Ghostlands
  [3824] = 3522, -- Bloodmaul Ravine -> Blade's Edge Mountains
  [3825] = 3522, -- Dragons' End -> Blade's Edge Mountains
  [3826] = 3522, -- Daggermaw Canyon -> Blade's Edge Mountains
  [3827] = 3522, -- Vekhaar Stand -> Blade's Edge Mountains
  [3828] = 3522, -- Ruuan Weald -> Blade's Edge Mountains
  [3829] = 3522, -- Veil Ruuan -> Blade's Edge Mountains
  [3830] = 3522, -- Raven's Wood -> Blade's Edge Mountains
  [3831] = 3522, -- Death's Door -> Blade's Edge Mountains
  [3832] = 3522, -- Vortex Pinnacle -> Blade's Edge Mountains
  [3833] = 3522, -- Razor Ridge -> Blade's Edge Mountains
  [3834] = 3522, -- Ridge of Madness -> Blade's Edge Mountains
  [3835] = 3483, -- Dustquill Ravine -> Hellfire Peninsula
  [3837] = 3523, -- Sunfury Hold -> Netherstorm
  [3838] = 3483, -- Spinebreaker Mountains -> Hellfire Peninsula
  [3839] = 3518, -- Abandoned Armory -> Nagrand
  [3840] = 3959, -- The Black Temple -> Black Temple
  [3841] = 3521, -- Darkcrest Shore -> Zangarmarsh
  [3842] = 3523, -- Tempest Keep -> Netherstorm
  [3844] = 3522, -- Mok'Nathal Village -> Blade's Edge Mountains
  [3846] = 3848, -- The Arcatraz -> The Arcatraz
  [3850] = 3523, -- Netherstone -> Netherstorm
  [3851] = 3523, -- Midrealm Post -> Netherstorm
  [3852] = 3523, -- Tuluman's Landing -> Netherstorm
  [3854] = 3523, -- Protectorate Watch Post -> Netherstorm
  [3855] = 3522, -- Circle of Blood Arena -> Blade's Edge Mountains
  [3856] = 3433, -- Elrendar Crossing -> Ghostlands
  [3857] = 3524, -- Ammen Ford -> Azuremyst Isle
  [3858] = 3519, -- Razorthorn Shelf -> Terokkar Forest
  [3859] = 3519, -- Silmyr Lake -> Terokkar Forest
  [3860] = 3519, -- Raastok Glade -> Terokkar Forest
  [3861] = 3433, -- Thalassian Pass -> Ghostlands
  [3862] = 3522, -- Churning Gulch -> Blade's Edge Mountains
  [3863] = 3522, -- Broken Wilds -> Blade's Edge Mountains
  [3864] = 3522, -- Bash'ir Landing -> Blade's Edge Mountains
  [3865] = 3522, -- Crystal Spine -> Blade's Edge Mountains
  [3866] = 3522, -- Skald -> Blade's Edge Mountains
  [3867] = 3522, -- Bladed Gulch -> Blade's Edge Mountains
  [3868] = 3523, -- Gyro-Plank Bridge -> Netherstorm
  [3869] = 3820, -- Mage Tower -> Eye of the Storm
  [3870] = 3820, -- Blood Elf Tower -> Eye of the Storm
  [3871] = 3820, -- Draenei Ruins -> Eye of the Storm
  [3872] = 3820, -- Fel Reaver Ruins -> Eye of the Storm
  [3873] = 3523, -- The Proving Grounds -> Netherstorm
  [3874] = 3523, -- Eco-Dome Farfield -> Netherstorm
  [3875] = 3523, -- Eco-Dome Skyperch -> Netherstorm
  [3876] = 3523, -- Eco-Dome Sutheron -> Netherstorm
  [3877] = 3523, -- Eco-Dome Midrealm -> Netherstorm
  [3878] = 3523, -- Ethereum Staging Grounds -> Netherstorm
  [3879] = 3523, -- Chapel Yard -> Netherstorm
  [3880] = 3523, -- Access Shaft Zeon -> Netherstorm
  [3881] = 3523, -- Trelleum Mine -> Netherstorm
  [3882] = 3523, -- Invasion Point: Destroyer -> Netherstorm
  [3883] = 3523, -- Camp of Boom -> Netherstorm
  [3884] = 3483, -- Spinebreaker Pass -> Hellfire Peninsula
  [3885] = 3519, -- Netherweb Ridge -> Terokkar Forest
  [3886] = 3519, -- Derelict Caravan -> Terokkar Forest
  [3887] = 3519, -- Refugee Caravan -> Terokkar Forest
  [3888] = 3519, -- Shadow Tomb -> Terokkar Forest
  [3889] = 3519, -- Veil Rhaze -> Terokkar Forest
  [3890] = 3519, -- Tomb of Lights -> Terokkar Forest
  [3891] = 3519, -- Carrion Hill -> Terokkar Forest
  [3892] = 3519, -- Writhing Mound -> Terokkar Forest
  [3893] = 3519, -- Ring of Observance -> Terokkar Forest
  [3894] = 3519, -- Auchenai Grounds -> Terokkar Forest
  [3895] = 3521, -- Cenarion Watchpost -> Zangarmarsh
  [3896] = 3703, -- Aldor Rise -> Shattrath City
  [3897] = 3703, -- Terrace of Light -> Shattrath City
  [3898] = 3703, -- Scryer's Tier -> Shattrath City
  [3899] = 3703, -- Lower City -> Shattrath City
  [3900] = 3523, -- Invasion Point: Overlord -> Netherstorm
  [3901] = 3519, -- Allerian Post -> Terokkar Forest
  [3902] = 3519, -- Stonebreaker Camp -> Terokkar Forest
  [3903] = 3522, -- Boulder'mok -> Blade's Edge Mountains
  [3904] = 3522, -- Cursed Hollow -> Blade's Edge Mountains
  [3905] = 3607, -- Coilfang Reservoir -> Serpentshrine Cavern
  [3906] = 3525, -- The Bloodwash -> Bloodmyst Isle
  [3907] = 3525, -- Veridian Point -> Bloodmyst Isle
  [3908] = 3525, -- Middenvale -> Bloodmyst Isle
  [3909] = 3525, -- The Lost Fold -> Bloodmyst Isle
  [3910] = 3525, -- Mystwood -> Bloodmyst Isle
  [3911] = 3430, -- Tranquil Shore -> Eversong Woods
  [3912] = 3430, -- Goldenbough Pass -> Eversong Woods
  [3913] = 3430, -- Runestone Falithas -> Eversong Woods
  [3914] = 3430, -- Runestone Shan'dor -> Eversong Woods
  [3915] = 3524, -- Fairbridge Strand -> Azuremyst Isle
  [3916] = 3524, -- Moongraze Woods -> Azuremyst Isle
  [3918] = 3522, -- Toshley's Station -> Blade's Edge Mountains
  [3919] = 3522, -- Singing Ridge -> Blade's Edge Mountains
  [3920] = 3483, -- Shatter Point -> Hellfire Peninsula
  [3921] = 3523, -- Arklonis Ridge -> Netherstorm
  [3922] = 3522, -- Bladespire Outpost -> Blade's Edge Mountains
  [3924] = 3522, -- Northmaul Tower -> Blade's Edge Mountains
  [3925] = 3522, -- Southmaul Tower -> Blade's Edge Mountains
  [3926] = 3520, -- Shattered Plains -> Shadowmoon Valley
  [3927] = 3520, -- Oronok's Farm -> Shadowmoon Valley
  [3928] = 3520, -- The Altar of Damnation -> Shadowmoon Valley
  [3929] = 3520, -- The Path of Conquest -> Shadowmoon Valley
  [3930] = 3520, -- Eclipsion Fields -> Shadowmoon Valley
  [3931] = 3522, -- Bladespire Grounds -> Blade's Edge Mountains
  [3932] = 3520, -- Sketh'lon Base Camp -> Shadowmoon Valley
  [3933] = 3520, -- Sketh'lon Wreckage -> Shadowmoon Valley
  [3934] = 3523, -- Town Square -> Netherstorm
  [3935] = 3523, -- Wizard Row -> Netherstorm
  [3936] = 3520, -- Deathforge Tower -> Shadowmoon Valley
  [3937] = 3520, -- Slag Watch -> Shadowmoon Valley
  [3938] = 3520, -- Sanctum of the Stars -> Shadowmoon Valley
  [3939] = 3520, -- Dragonmaw Fortress -> Shadowmoon Valley
  [3940] = 3520, -- The Fetid Pool -> Shadowmoon Valley
  [3941] = 3520, -- Test -> Shadowmoon Valley
  [3942] = 3522, -- Razaan's Landing -> Blade's Edge Mountains
  [3943] = 3520, -- Invasion Point: Cataclysm -> Shadowmoon Valley
  [3944] = 3520, -- The Altar of Shadows -> Shadowmoon Valley
  [3945] = 3520, -- Netherwing Pass -> Shadowmoon Valley
  [3946] = 3519, -- Wayne's Refuge -> Terokkar Forest
  [3947] = 3520, -- The Scalding Pools -> Shadowmoon Valley
  [3949] = 3520, -- Magma Fields -> Shadowmoon Valley
  [3950] = 3520, -- Crimson Watch -> Shadowmoon Valley
  [3951] = 3522, -- Evergrove -> Blade's Edge Mountains
  [3952] = 3522, -- Wyrmskull Bridge -> Blade's Edge Mountains
  [3953] = 3522, -- Scalewing Shelf -> Blade's Edge Mountains
  [3954] = 3522, -- Wyrmskull Tunnel -> Blade's Edge Mountains
  [3955] = 3483, -- Hellfire Basin -> Hellfire Peninsula
  [3956] = 3519, -- The Shadow Stair -> Terokkar Forest
  [3957] = 3519, -- Sha'tari Outpost -> Terokkar Forest
  [3958] = 3519, -- Sha'tari Base Camp -> Terokkar Forest
  [3960] = 3522, -- Soulgrinder's Barrow -> Blade's Edge Mountains
  [3961] = 3519, -- Sorrow Wing Point -> Terokkar Forest
  [3962] = 3522, -- Vim'gol's Circle -> Blade's Edge Mountains
  [3963] = 3522, -- Dragonspine Ridge -> Blade's Edge Mountains
  [3964] = 3522, -- Skyguard Outpost -> Blade's Edge Mountains
  [3965] = 3520, -- Netherwing Mines -> Shadowmoon Valley
  [3966] = 3520, -- Dragonmaw Base Camp -> Shadowmoon Valley
  [3967] = 3520, -- Dragonmaw Skyway -> Shadowmoon Valley
  [3969] = 3522, -- Rivendark's Perch -> Blade's Edge Mountains
  [3970] = 3522, -- Obsidia's Perch -> Blade's Edge Mountains
  [3971] = 3522, -- Insidion's Perch -> Blade's Edge Mountains
  [3972] = 3522, -- Furywing's Perch -> Blade's Edge Mountains
  [3973] = 3519, -- Blackwind Landing -> Terokkar Forest
  [3974] = 3519, -- Veil Harr'ik -> Terokkar Forest
  [3975] = 3519, -- Terokk's Rest -> Terokkar Forest
  [3976] = 3519, -- Veil Ala'rak -> Terokkar Forest
  [3977] = 3519, -- Upper Veil Shil'ak -> Terokkar Forest
  [3978] = 3519, -- Lower Veil Shil'ak -> Terokkar Forest
  [3980] = 495, -- Daggercap Bay -> Howling Fjord
  [3981] = 495, -- Valgarde -> Howling Fjord
  [3982] = 495, -- Wyrmskull Village -> Howling Fjord
  [3983] = 206, -- Utgarde Keep -> Utgarde Keep
  [3984] = 495, -- Nifflevar -> Howling Fjord
  [3985] = 495, -- Falls of Ymiron -> Howling Fjord
  [3986] = 495, -- Echo Reach -> Howling Fjord
  [3987] = 495, -- The Isle of Spears -> Howling Fjord
  [3988] = 495, -- Kamagua -> Howling Fjord
  [3989] = 495, -- Garvan's Reef -> Howling Fjord
  [3990] = 495, -- Scalawag Point -> Howling Fjord
  [3991] = 495, -- New Agamand -> Howling Fjord
  [3992] = 495, -- The Ancient Lift -> Howling Fjord
  [3993] = 495, -- Westguard Turret -> Howling Fjord
  [3994] = 495, -- Halgrind -> Howling Fjord
  [3995] = 495, -- The Laughing Stand -> Howling Fjord
  [3996] = 495, -- Baelgun's Excavation Site -> Howling Fjord
  [3997] = 495, -- Explorers' League Outpost -> Howling Fjord
  [3998] = 495, -- Westguard Keep -> Howling Fjord
  [3999] = 495, -- Steel Gate -> Howling Fjord
  [4000] = 495, -- Vengeance Landing -> Howling Fjord
  [4001] = 495, -- Baleheim -> Howling Fjord
  [4002] = 495, -- Skorn -> Howling Fjord
  [4003] = 495, -- Fort Wildervar -> Howling Fjord
  [4004] = 495, -- Vileprey Village -> Howling Fjord
  [4005] = 495, -- Ivald's Ruin -> Howling Fjord
  [4006] = 495, -- Gjalerbron -> Howling Fjord
  [4007] = 495, -- Tomb of the Lost Kings -> Howling Fjord
  [4008] = 3522, -- Shartuul's Transporter -> Blade's Edge Mountains
  [4009] = 3959, -- Illidari Training Grounds -> Black Temple
  [4010] = 15, -- Mudsprocket -> Dustwallow Marsh
  [4018] = 495, -- Camp Winterhoof -> Howling Fjord
  [4020] = 3537, -- Mightstone Quarry -> Borean Tundra
  [4021] = 3537, -- Bloodspore Plains -> Borean Tundra
  [4022] = 3537, -- Gammoth -> Borean Tundra
  [4023] = 3537, -- Amber Ledge -> Borean Tundra
  [4024] = 3537, -- Coldarra -> Borean Tundra
  [4025] = 3537, -- The Westrift -> Borean Tundra
  [4026] = 3537, -- The Transitus Stair -> Borean Tundra
  [4027] = 3537, -- Coast of Echoes -> Borean Tundra
  [4028] = 3537, -- Riplash Strand -> Borean Tundra
  [4029] = 3537, -- Riplash Ruins -> Borean Tundra
  [4030] = 3537, -- Coast of Idols -> Borean Tundra
  [4031] = 3537, -- Pal'ea -> Borean Tundra
  [4032] = 3537, -- Valiance Keep -> Borean Tundra
  [4033] = 3537, -- Winterfin Village -> Borean Tundra
  [4034] = 3537, -- The Borean Wall -> Borean Tundra
  [4035] = 3537, -- The Geyser Fields -> Borean Tundra
  [4036] = 3537, -- Fizzcrank Pumping Station -> Borean Tundra
  [4037] = 3537, -- Taunka'le Village -> Borean Tundra
  [4038] = 3537, -- Magnamoth Caverns -> Borean Tundra
  [4039] = 3537, -- Coldrock Quarry -> Borean Tundra
  [4040] = 3537, -- Njord's Breath Bay -> Borean Tundra
  [4041] = 3537, -- Kaskala -> Borean Tundra
  [4042] = 3537, -- Transborea -> Borean Tundra
  [4043] = 3537, -- The Flood Plains -> Borean Tundra
  [4046] = 15, -- Direhorn Post -> Dustwallow Marsh
  [4047] = 15, -- Nat's Landing -> Dustwallow Marsh
  [4048] = 495, -- Ember Clutch -> Howling Fjord
  [4049] = 15, -- Tabetha's Farm -> Dustwallow Marsh
  [4050] = 495, -- Derelict Strand -> Howling Fjord
  [4051] = 495, -- The Frozen Glade -> Howling Fjord
  [4052] = 495, -- The Vibrant Glade -> Howling Fjord
  [4053] = 495, -- The Twisted Glade -> Howling Fjord
  [4054] = 495, -- Rivenwood -> Howling Fjord
  [4055] = 495, -- Caldemere Lake -> Howling Fjord
  [4056] = 495, -- Utgarde Catacombs -> Howling Fjord
  [4057] = 495, -- Shield Hill -> Howling Fjord
  [4058] = 495, -- Lake Cauldros -> Howling Fjord
  [4059] = 495, -- Cauldros Isle -> Howling Fjord
  [4060] = 495, -- Bleeding Vale -> Howling Fjord
  [4061] = 495, -- Giants' Run -> Howling Fjord
  [4062] = 495, -- Apothecary Camp -> Howling Fjord
  [4063] = 495, -- Ember Spear Tower -> Howling Fjord
  [4064] = 495, -- Shattered Straits -> Howling Fjord
  [4065] = 495, -- Gjalerhorn -> Howling Fjord
  [4066] = 495, -- Frostblade Peak -> Howling Fjord
  [4067] = 139, -- Plaguewood Tower -> Eastern Plaguelands
  [4068] = 495, -- West Spear Tower -> Howling Fjord
  [4069] = 495, -- North Spear Tower -> Howling Fjord
  [4070] = 495, -- Chillmere Coast -> Howling Fjord
  [4071] = 495, -- Whisper Gulch -> Howling Fjord
  [4072] = 151, -- Sub zone -> Designer Island
  [4073] = 495, -- Winter's Terrace -> Howling Fjord
  [4074] = 495, -- The Waking Halls -> Howling Fjord
  [4077] = 495, -- Sorlof's Strand -> Howling Fjord
  [4078] = 3519, -- Razorthorn Rise -> Terokkar Forest
  [4079] = 495, -- Frostblade Pass -> Howling Fjord
  [4081] = 4080, -- The Dawnchaser -> Isle of Quel'Danas
  [4082] = 4080, -- The Sin'loren -> Isle of Quel'Danas
  [4083] = 4080, -- Silvermoon's Pride -> Isle of Quel'Danas
  [4084] = 4080, -- The Bloodoath -> Isle of Quel'Danas
  [4085] = 4080, -- Shattered Sun Staging Area -> Isle of Quel'Danas
  [4086] = 4080, -- Sun's Reach Sanctum -> Isle of Quel'Danas
  [4087] = 4080, -- Sun's Reach Harbor -> Isle of Quel'Danas
  [4088] = 4080, -- Sun's Reach Armory -> Isle of Quel'Danas
  [4089] = 4080, -- Dawnstar Village -> Isle of Quel'Danas
  [4090] = 4080, -- The Dawning Square -> Isle of Quel'Danas
  [4091] = 4080, -- Greengill Coast -> Isle of Quel'Danas
  [4092] = 4080, -- The Dead Scar -> Isle of Quel'Danas
  [4093] = 4080, -- The Sun Forge -> Isle of Quel'Danas
  [4094] = 4075, -- Sunwell Plateau -> Sunwell Plateau
  [4095] = 4131, -- Magisters' Terrace -> Magisters' Terrace
  [4096] = 4019, -- Claytön's WoWEdit Land -> Development Land
  [4097] = 3537, -- Winterfin Caverns -> Borean Tundra
  [4098] = 3537, -- Glimmer Bay -> Borean Tundra
  [4099] = 3537, -- Winterfin Retreat -> Borean Tundra
  [4101] = 3537, -- Sands of Nasam -> Borean Tundra
  [4102] = 3537, -- Krom's Landing -> Borean Tundra
  [4103] = 3537, -- Nasam's Talon -> Borean Tundra
  [4104] = 3537, -- Echo Cove -> Borean Tundra
  [4105] = 3537, -- Beryl Point -> Borean Tundra
  [4106] = 3537, -- Garrosh's Landing -> Borean Tundra
  [4107] = 3537, -- Warsong Jetty -> Borean Tundra
  [4108] = 3537, -- Fizzcrank Airstrip -> Borean Tundra
  [4109] = 3537, -- Lake Kum'uya -> Borean Tundra
  [4110] = 3537, -- Farshire Fields -> Borean Tundra
  [4111] = 3537, -- Farshire -> Borean Tundra
  [4112] = 3537, -- Farshire Lighthouse -> Borean Tundra
  [4113] = 3537, -- Unu'pe -> Borean Tundra
  [4114] = 3537, -- Death's Stand -> Borean Tundra
  [4115] = 3537, -- The Abandoned Reach -> Borean Tundra
  [4116] = 3537, -- Scalding Pools -> Borean Tundra
  [4117] = 3537, -- Steam Springs -> Borean Tundra
  [4118] = 3537, -- Talramas -> Borean Tundra
  [4119] = 3537, -- Festering Pools -> Borean Tundra
  [4120] = 4265, -- The Nexus -> The Nexus
  [4121] = 3537, -- Transitus Shield -> Borean Tundra
  [4122] = 3537, -- Bor'gorok Outpost -> Borean Tundra
  [4123] = 3537, -- Magmoth -> Borean Tundra
  [4124] = 3537, -- The Dens of Dying -> Borean Tundra
  [4125] = 3537, -- Temple City of En'kilah -> Borean Tundra
  [4126] = 3537, -- The Wailing Ziggurat -> Borean Tundra
  [4127] = 3537, -- Steeljaw's Caravan -> Borean Tundra
  [4128] = 3537, -- Naxxanar -> Borean Tundra
  [4129] = 3537, -- Warsong Hold -> Borean Tundra
  [4130] = 3537, -- Plains of Nasam -> Borean Tundra
  [4132] = 3537, -- Ruins of Eldra'nath -> Borean Tundra
  [4133] = 3537, -- Charred Rise -> Borean Tundra
  [4134] = 3537, -- Blistering Pool -> Borean Tundra
  [4135] = 3537, -- Spire of Blood -> Borean Tundra
  [4136] = 3537, -- Spire of Decay -> Borean Tundra
  [4137] = 3537, -- Spire of Pain -> Borean Tundra
  [4138] = 3537, -- Frozen Reach -> Borean Tundra
  [4139] = 4075, -- Parhelion Plaza -> Sunwell Plateau
  [4140] = 4075, -- The Dead Scar -> Sunwell Plateau
  [4141] = 3537, -- Torp's Farm -> Borean Tundra
  [4142] = 3537, -- Warsong Granary -> Borean Tundra
  [4143] = 3537, -- Warsong Slaughterhouse -> Borean Tundra
  [4144] = 3537, -- Warsong Farms Outpost -> Borean Tundra
  [4145] = 3537, -- West Point Station -> Borean Tundra
  [4146] = 3537, -- North Point Station -> Borean Tundra
  [4147] = 3537, -- Mid Point Station -> Borean Tundra
  [4148] = 3537, -- South Point Station -> Borean Tundra
  [4149] = 3537, -- D.E.H.T.A. Encampment -> Borean Tundra
  [4150] = 3537, -- Kaw's Roost -> Borean Tundra
  [4151] = 65, -- Westwind Refugee Camp -> Dragonblight
  [4152] = 65, -- Moa'ki Harbor -> Dragonblight
  [4153] = 65, -- Indu'le Village -> Dragonblight
  [4154] = 65, -- Snowfall Glade -> Dragonblight
  [4155] = 65, -- The Half Shell -> Dragonblight
  [4156] = 65, -- Surge Needle -> Dragonblight
  [4157] = 65, -- Moonrest Gardens -> Dragonblight
  [4158] = 65, -- Stars' Rest -> Dragonblight
  [4159] = 394, -- Westfall Brigade Encampment -> Grizzly Hills
  [4160] = 65, -- Lothalor Woodlands -> Dragonblight
  [4161] = 65, -- Wyrmrest Temple -> Dragonblight
  [4162] = 65, -- Icemist Falls -> Dragonblight
  [4163] = 65, -- Icemist Village -> Dragonblight
  [4164] = 65, -- The Pit of Narjun -> Dragonblight
  [4165] = 65, -- Agmar's Hammer -> Dragonblight
  [4166] = 65, -- Lake Indu'le -> Dragonblight
  [4167] = 65, -- Obsidian Dragonshrine -> Dragonblight
  [4168] = 65, -- Ruby Dragonshrine -> Dragonblight
  [4169] = 65, -- Fordragon Hold -> Dragonblight
  [4170] = 65, -- Kor'kron Vanguard -> Dragonblight
  [4171] = 65, -- The Court of Skulls -> Dragonblight
  [4172] = 65, -- Angrathar the Wrathgate -> Dragonblight
  [4173] = 65, -- Galakrond's Rest -> Dragonblight
  [4174] = 65, -- The Wicked Coil -> Dragonblight
  [4175] = 65, -- Bronze Dragonshrine -> Dragonblight
  [4176] = 65, -- The Mirror of Dawn -> Dragonblight
  [4177] = 65, -- Wintergarde Keep -> Dragonblight
  [4178] = 65, -- Wintergarde Mine -> Dragonblight
  [4179] = 65, -- Emerald Dragonshrine -> Dragonblight
  [4180] = 65, -- New Hearthglen -> Dragonblight
  [4181] = 65, -- Crusader's Landing -> Dragonblight
  [4182] = 65, -- Sinner's Folly -> Dragonblight
  [4183] = 65, -- Azure Dragonshrine -> Dragonblight
  [4184] = 65, -- Path of the Titans -> Dragonblight
  [4185] = 65, -- The Forgotten Shore -> Dragonblight
  [4186] = 65, -- Venomspite -> Dragonblight
  [4187] = 65, -- The Crystal Vice -> Dragonblight
  [4188] = 65, -- The Carrion Fields -> Dragonblight
  [4189] = 65, -- Onslaught Base Camp -> Dragonblight
  [4190] = 65, -- Thorson's Post -> Dragonblight
  [4191] = 65, -- Light's Trust -> Dragonblight
  [4192] = 65, -- Frostmourne Cavern -> Dragonblight
  [4193] = 65, -- Scarlet Point -> Dragonblight
  [4194] = 65, -- Jintha'kalar -> Dragonblight
  [4195] = 65, -- Ice Heart Cavern -> Dragonblight
  [4198] = 65, -- Kili'ua's Atoll -> Dragonblight
  [4199] = 394, -- Silverbrook -> Grizzly Hills
  [4200] = 394, -- Vordrassil's Heart -> Grizzly Hills
  [4202] = 4201, -- Vordrassil's Tears -> Vordrassil's Tears
  [4203] = 394, -- Vordrassil's Limb -> Grizzly Hills
  [4204] = 394, -- Amberpine Lodge -> Grizzly Hills
  [4205] = 394, -- Solstice Village -> Grizzly Hills
  [4206] = 394, -- Conquest Hold -> Grizzly Hills
  [4207] = 394, -- Voldrune -> Grizzly Hills
  [4208] = 394, -- Granite Springs -> Grizzly Hills
  [4209] = 394, -- Zeb'Halak -> Grizzly Hills
  [4210] = 394, -- Drak'Tharon Keep -> Grizzly Hills
  [4211] = 394, -- Camp Oneqwah -> Grizzly Hills
  [4212] = 394, -- Eastwind Shore -> Grizzly Hills
  [4213] = 394, -- The Broken Bluffs -> Grizzly Hills
  [4214] = 394, -- Boulder Hills -> Grizzly Hills
  [4215] = 394, -- Rage Fang Shrine -> Grizzly Hills
  [4216] = 394, -- Drakil'jin Ruins -> Grizzly Hills
  [4217] = 394, -- Blackriver Logging Camp -> Grizzly Hills
  [4218] = 394, -- Heart's Blood Shrine -> Grizzly Hills
  [4219] = 394, -- Hollowstone Mine -> Grizzly Hills
  [4220] = 394, -- Dun Argol -> Grizzly Hills
  [4221] = 394, -- Thor Modan -> Grizzly Hills
  [4222] = 394, -- Blue Sky Logging Grounds -> Grizzly Hills
  [4223] = 65, -- Maw of Neltharion -> Dragonblight
  [4224] = 65, -- The Briny Pinnacle -> Dragonblight
  [4225] = 65, -- Glittering Strand -> Dragonblight
  [4226] = 495, -- Iskaal -> Howling Fjord
  [4227] = 65, -- Dragon's Fall -> Dragonblight
  [4229] = 394, -- Prospector's Point -> Grizzly Hills
  [4230] = 65, -- Coldwind Heights -> Dragonblight
  [4231] = 394, -- Redwood Trading Post -> Grizzly Hills
  [4232] = 65, -- Vengeance Pass -> Dragonblight
  [4233] = 65, -- Dawn's Reach -> Dragonblight
  [4234] = 65, -- Naxxramas -> Dragonblight
  [4235] = 394, -- Heartwood Trading Post -> Grizzly Hills
  [4236] = 394, -- Evergreen Trading Post -> Grizzly Hills
  [4237] = 394, -- Spruce Point Post -> Grizzly Hills
  [4238] = 394, -- White Pine Trading Post -> Grizzly Hills
  [4239] = 394, -- Aspen Grove Post -> Grizzly Hills
  [4240] = 394, -- Forest's Edge Post -> Grizzly Hills
  [4241] = 65, -- Eldritch Heights -> Dragonblight
  [4242] = 394, -- Venture Bay -> Grizzly Hills
  [4243] = 65, -- Wintergarde Crypt -> Dragonblight
  [4244] = 394, -- Bloodmoon Isle -> Grizzly Hills
  [4245] = 394, -- Shadowfang Tower -> Grizzly Hills
  [4246] = 65, -- Wintergarde Mausoleum -> Dragonblight
  [4247] = 394, -- Duskhowl Den -> Grizzly Hills
  [4248] = 394, -- The Conquest Pit -> Grizzly Hills
  [4249] = 394, -- The Path of Iron -> Grizzly Hills
  [4250] = 394, -- Ruins of Tethys -> Grizzly Hills
  [4251] = 394, -- Silverbrook Hills -> Grizzly Hills
  [4252] = 495, -- The Broken Bluffs -> Howling Fjord
  [4253] = 65, -- 7th Legion Front -> Dragonblight
  [4254] = 65, -- The Dragon Wastes -> Dragonblight
  [4255] = 394, -- Ruins of Drak'Zin -> Grizzly Hills
  [4256] = 65, -- Drak'Mar Lake -> Dragonblight
  [4257] = 65, -- Dragonspine Tributary -> Dragonblight
  [4259] = 394, -- Drak'ural -> Grizzly Hills
  [4260] = 495, -- Thorvald's Camp -> Howling Fjord
  [4261] = 495, -- Ghostblade Post -> Howling Fjord
  [4262] = 394, -- Ashwood Post -> Grizzly Hills
  [4263] = 495, -- Lydell's Ambush -> Howling Fjord
  [4266] = 394, -- Harkor's Camp -> Grizzly Hills
  [4267] = 394, -- Vordrassil Pass -> Grizzly Hills
  [4268] = 394, -- Ruuna's Camp -> Grizzly Hills
  [4269] = 3537, -- Shrine of Scales -> Borean Tundra
  [4270] = 394, -- Drak'atal Passage -> Grizzly Hills
  [4271] = 1196, -- Utgarde Pinnacle -> Utgarde Pinnacle
  [4274] = 139, -- Halls of Lightning - The Terrestrial Watchtower (fake ID for Halls of Lightning)
  [4275] = 66, -- The Argent Stand -> Zul'Drak
  [4276] = 66, -- Altar of Sseratus -> Zul'Drak
  [4278] = 66, -- Drak'Sotra Fields -> Zul'Drak
  [4279] = 66, -- Drak'Sotra -> Zul'Drak
  [4280] = 66, -- Drak'Agal -> Zul'Drak
  [4281] = 139, -- Acherus: The Ebon Hold -> Eastern Plaguelands
  [4282] = 3711, -- The Avalanche -> Sholazar Basin
  [4283] = 3711, -- The Lost Lands -> Sholazar Basin
  [4284] = 3711, -- Nesingwary Base Camp -> Sholazar Basin
  [4285] = 3711, -- The Seabreach Flow -> Sholazar Basin
  [4286] = 3711, -- The Bones of Nozronn -> Sholazar Basin
  [4287] = 3711, -- Kartak's Hold -> Sholazar Basin
  [4288] = 3711, -- Sparktouched Haven -> Sholazar Basin
  [4289] = 3711, -- The Path of the Lifewarden -> Sholazar Basin
  [4290] = 3711, -- River's Heart -> Sholazar Basin
  [4291] = 3711, -- Rainspeaker Canopy -> Sholazar Basin
  [4292] = 3711, -- Frenzyheart Hill -> Sholazar Basin
  [4293] = 3711, -- Wildgrowth Mangal -> Sholazar Basin
  [4294] = 66, -- Heb'Valok -> Zul'Drak
  [4295] = 3711, -- The Sundered Shard -> Sholazar Basin
  [4296] = 3711, -- The Lifeblood Pillar -> Sholazar Basin
  [4297] = 3711, -- Mosswalker Village -> Sholazar Basin
  [4299] = 66, -- Kolramas -> Zul'Drak
  [4300] = 3711, -- Waygate -> Sholazar Basin
  [4301] = 4277, -- Azjol-Nerub - The BroodPit (fake ID for Azjol-Nerub)
  [4302] = 3711, -- The Skyreach Pillar -> Sholazar Basin
  [4303] = 3711, -- Hardknuckle Clearing -> Sholazar Basin
  [4304] = 3711, -- Sapphire Hive -> Sholazar Basin
  [4306] = 3711, -- Mistwhisper Refuge -> Sholazar Basin
  [4307] = 3711, -- The Glimmering Pillar -> Sholazar Basin
  [4308] = 3711, -- Spearborn Encampment -> Sholazar Basin
  [4309] = 66, -- Drak'Tharon Keep -> Zul'Drak
  [4310] = 66, -- Zeramas -> Zul'Drak
  [4311] = 66, -- Reliquary of Agony -> Zul'Drak
  [4312] = 66, -- Ebon Watch -> Zul'Drak
  [4313] = 66, -- Thrym's End -> Zul'Drak
  [4314] = 66, -- Voltarus -> Zul'Drak
  [4315] = 66, -- Reliquary of Pain -> Zul'Drak
  [4316] = 66, -- Rageclaw Den -> Zul'Drak
  [4317] = 66, -- Light's Breach -> Zul'Drak
  [4318] = 66, -- Pools of Zha'Jin -> Zul'Drak
  [4319] = 66, -- Zim'Abwa -> Zul'Drak
  [4320] = 66, -- Amphitheater of Anguish -> Zul'Drak
  [4321] = 66, -- Altar of Rhunok -> Zul'Drak
  [4322] = 66, -- Altar of Har'koa -> Zul'Drak
  [4323] = 66, -- Zim'Torga -> Zul'Drak
  [4324] = 66, -- Pools of Jin'Alai -> Zul'Drak
  [4325] = 66, -- Altar of Quetz'lun -> Zul'Drak
  [4326] = 66, -- Heb'Drakkar -> Zul'Drak
  [4327] = 66, -- Drak'Mabwa -> Zul'Drak
  [4328] = 66, -- Zim'Rhuk -> Zul'Drak
  [4329] = 66, -- Altar of Mam'toth -> Zul'Drak
  [4342] = 4298, -- Acherus: The Ebon Hold -> Plaguelands: The Scarlet Enclave
  [4343] = 4298, -- New Avalon -> Plaguelands: The Scarlet Enclave
  [4344] = 4298, -- New Avalon Fields -> Plaguelands: The Scarlet Enclave
  [4345] = 4298, -- New Avalon Orchard -> Plaguelands: The Scarlet Enclave
  [4346] = 4298, -- New Avalon Town Hall -> Plaguelands: The Scarlet Enclave
  [4347] = 4298, -- Havenshire -> Plaguelands: The Scarlet Enclave
  [4348] = 4298, -- Havenshire Farms -> Plaguelands: The Scarlet Enclave
  [4349] = 4298, -- Havenshire Lumber Mill -> Plaguelands: The Scarlet Enclave
  [4350] = 4298, -- Havenshire Stables -> Plaguelands: The Scarlet Enclave
  [4351] = 4298, -- Scarlet Hold -> Plaguelands: The Scarlet Enclave
  [4352] = 4298, -- Chapel of the Crimson Flame -> Plaguelands: The Scarlet Enclave
  [4353] = 4298, -- Light's Point Tower -> Plaguelands: The Scarlet Enclave
  [4354] = 4298, -- Light's Point -> Plaguelands: The Scarlet Enclave
  [4355] = 4298, -- Crypt of Remembrance -> Plaguelands: The Scarlet Enclave
  [4356] = 4298, -- Death's Breach -> Plaguelands: The Scarlet Enclave
  [4357] = 4298, -- The Noxious Glade -> Plaguelands: The Scarlet Enclave
  [4358] = 4298, -- Tyr's Hand -> Plaguelands: The Scarlet Enclave
  [4359] = 4298, -- King's Harbor -> Plaguelands: The Scarlet Enclave
  [4360] = 4298, -- Scarlet Overlook -> Plaguelands: The Scarlet Enclave
  [4361] = 4298, -- Light's Hope Chapel -> Plaguelands: The Scarlet Enclave
  [4362] = 4298, -- Sinner's Folly -> Plaguelands: The Scarlet Enclave
  [4363] = 4298, -- Pestilent Scar -> Plaguelands: The Scarlet Enclave
  [4364] = 4298, -- Browman Mill -> Plaguelands: The Scarlet Enclave
  [4365] = 4298, -- Havenshire Mine -> Plaguelands: The Scarlet Enclave
  [4366] = 394, -- Ursoc's Den -> Grizzly Hills
  [4367] = 3711, -- The Blight Line -> Sholazar Basin
  [4368] = 3711, -- The Bonefields -> Sholazar Basin
  [4369] = 3711, -- Dorian's Outpost -> Sholazar Basin
  [4371] = 66, -- Mam'toth Crater -> Zul'Drak
  [4372] = 66, -- Zol'Maz Stronghold -> Zul'Drak
  [4373] = 66, -- Zol'Heb -> Zul'Drak
  [4374] = 66, -- Rageclaw Lake -> Zul'Drak
  [4376] = 3711, -- The Savage Thicket -> Sholazar Basin
  [4377] = 4298, -- New Avalon Forge -> Plaguelands: The Scarlet Enclave
  [4379] = 495, -- Valgarde -> Howling Fjord
  [4380] = 495, -- Westguard Inn -> Howling Fjord
  [4381] = 490, -- Waygate -> Un'Goro Crater
  [4382] = 490, -- The Shaper's Terrace -> Un'Goro Crater
  [4383] = 3711, -- Lakeside Landing -> Sholazar Basin
  [4385] = 3711, -- Bittertide Lake -> Sholazar Basin
  [4386] = 3711, -- Rainspeaker Rapids -> Sholazar Basin
  [4387] = 3711, -- Frenzyheart River -> Sholazar Basin
  [4388] = 3711, -- Wintergrasp River -> Sholazar Basin
  [4389] = 3711, -- The Suntouched Pillar -> Sholazar Basin
  [4390] = 66, -- Frigid Breach -> Zul'Drak
  [4391] = 3711, -- Swindlegrin's Dig -> Sholazar Basin
  [4392] = 3711, -- The Stormwright's Shelf -> Sholazar Basin
  [4393] = 3711, -- Death's Hand Encampment -> Sholazar Basin
  [4394] = 4298, -- Scarlet Tavern -> Plaguelands: The Scarlet Enclave
  [4396] = 65, -- Nozzlerust Post -> Dragonblight
  [4399] = 3537, -- Farshire Mine -> Borean Tundra
  [4400] = 3711, -- The Mosslight Pillar -> Sholazar Basin
  [4401] = 3537, -- Saragosa's Landing -> Borean Tundra
  [4402] = 495, -- Vengeance Lift -> Howling Fjord
  [4403] = 495, -- Balejar Watch -> Howling Fjord
  [4404] = 495, -- New Agamand Inn -> Howling Fjord
  [4405] = 4277, -- Passage of Lost Fiends -> Azjol-Nerub
  [4407] = 2597, -- Hall of the Frostwolf -> Alterac Valley
  [4408] = 2597, -- Hall of the Stormpike -> Alterac Valley
  [4411] = 1519, -- Stormwind Harbor -> Stormwind City
  [4412] = 3711, -- The Makers' Overlook -> Sholazar Basin
  [4413] = 3711, -- The Makers' Perch -> Sholazar Basin
  [4414] = 65, -- Scarlet Tower -> Dragonblight
  [4417] = 210, -- Onslaught Harbor -> Icecrown
  [4418] = 67, -- K3 -> The Storm Peaks
  [4419] = 67, -- Snowblind Hills -> The Storm Peaks
  [4420] = 67, -- Snowblind Terrace -> The Storm Peaks
  [4421] = 67, -- Garm -> The Storm Peaks
  [4422] = 67, -- Brunnhildar Village -> The Storm Peaks
  [4423] = 67, -- Sifreldar Village -> The Storm Peaks
  [4424] = 67, -- Valkyrion -> The Storm Peaks
  [4425] = 67, -- The Forlorn Mine -> The Storm Peaks
  [4426] = 67, -- Bor's Breath River -> The Storm Peaks
  [4427] = 67, -- Argent Vanguard -> The Storm Peaks
  [4428] = 67, -- Frosthold -> The Storm Peaks
  [4429] = 67, -- Grom'arsh Crash-Site -> The Storm Peaks
  [4430] = 67, -- Temple of Storms -> The Storm Peaks
  [4431] = 67, -- Engine of the Makers -> The Storm Peaks
  [4432] = 67, -- The Foot Steppes -> The Storm Peaks
  [4433] = 67, -- Dragonspine Peaks -> The Storm Peaks
  [4434] = 67, -- Nidavelir -> The Storm Peaks
  [4435] = 67, -- Narvir's Cradle -> The Storm Peaks
  [4436] = 67, -- Snowdrift Plains -> The Storm Peaks
  [4437] = 67, -- Valley of Ancient Winters -> The Storm Peaks
  [4438] = 67, -- Dun Niffelem -> The Storm Peaks
  [4439] = 67, -- Frostfield Lake -> The Storm Peaks
  [4440] = 67, -- Thunderfall -> The Storm Peaks
  [4441] = 67, -- Camp Tunka'lo -> The Storm Peaks
  [4442] = 67, -- Brann's Base-Camp -> The Storm Peaks
  [4443] = 67, -- Gate of Echoes -> The Storm Peaks
  [4444] = 67, -- Plain of Echoes -> The Storm Peaks
  [4445] = 4273, -- Ulduar -> Ulduar
  [4446] = 67, -- Terrace of the Makers -> The Storm Peaks
  [4447] = 67, -- Gate of Lightning -> The Storm Peaks
  [4448] = 67, -- Path of the Titans -> The Storm Peaks
  [4449] = 67, -- Uldis -> The Storm Peaks
  [4450] = 67, -- Loken's Bargain -> The Storm Peaks
  [4451] = 67, -- Bor's Fall -> The Storm Peaks
  [4452] = 67, -- Bor's Breath -> The Storm Peaks
  [4453] = 67, -- Rohemdal Pass -> The Storm Peaks
  [4454] = 67, -- The Storm Foundry -> The Storm Peaks
  [4455] = 67, -- Hibernal Cavern -> The Storm Peaks
  [4456] = 394, -- Voldrune Dwelling -> Grizzly Hills
  [4457] = 67, -- Torseg's Rest -> The Storm Peaks
  [4458] = 67, -- Sparksocket Minefield -> The Storm Peaks
  [4459] = 67, -- Ricket's Folly -> The Storm Peaks
  [4460] = 67, -- Garm's Bane -> The Storm Peaks
  [4461] = 67, -- Garm's Rise -> The Storm Peaks
  [4462] = 67, -- Crystalweb Cavern -> The Storm Peaks
  [4463] = 67, -- Temple of Life -> The Storm Peaks
  [4464] = 67, -- Temple of Order -> The Storm Peaks
  [4465] = 67, -- Temple of Winter -> The Storm Peaks
  [4466] = 67, -- Temple of Invention -> The Storm Peaks
  [4467] = 210, -- Death's Rise -> Icecrown
  [4468] = 66, -- The Dead Fields -> Zul'Drak
  [4469] = 66, -- Dargath's Demise -> Zul'Drak
  [4470] = 210, -- The Hidden Hollow -> Icecrown
  [4471] = 4019, -- Bernau's Happy Fun Land -> Development Land
  [4472] = 67, -- Frostgrip's Hollow -> The Storm Peaks
  [4473] = 67, -- The Frigid Tomb -> The Storm Peaks
  [4474] = 495, -- Twin Shores -> Howling Fjord
  [4475] = 394, -- Zim'bo's Hideout -> Grizzly Hills
  [4476] = 67, -- Abandoned Camp -> The Storm Peaks
  [4477] = 210, -- The Shadow Vault -> Icecrown
  [4478] = 65, -- Coldwind Pass -> Dragonblight
  [4479] = 495, -- Winter's Breath Lake -> Howling Fjord
  [4480] = 394, -- The Forgotten Overlook -> Grizzly Hills
  [4481] = 66, -- Jintha'kalar Passage -> Zul'Drak
  [4482] = 394, -- Arriga Footbridge -> Grizzly Hills
  [4483] = 3711, -- The Lost Passage -> Sholazar Basin
  [4484] = 67, -- Bouldercrag's Refuge -> The Storm Peaks
  [4485] = 67, -- The Inventor's Library -> The Storm Peaks
  [4486] = 67, -- The Frozen Mine -> The Storm Peaks
  [4487] = 67, -- Frostfloe Deep -> The Storm Peaks
  [4488] = 67, -- The Howling Hollow -> The Storm Peaks
  [4489] = 66, -- Crusader Forward Camp -> Zul'Drak
  [4490] = 67, -- Stormcrest -> The Storm Peaks
  [4491] = 394, -- Bonesnap's Camp -> Grizzly Hills
  [4492] = 210, -- Ufrang's Hall -> Icecrown
  [4495] = 67, -- Fjorn's Anvil -> The Storm Peaks
  [4496] = 210, -- Jotunheim -> Icecrown
  [4497] = 210, -- Savage Ledge -> Icecrown
  [4498] = 210, -- Halls of the Ancestors -> Icecrown
  [4499] = 67, -- The Blighted Pool -> The Storm Peaks
  [4501] = 210, -- The Argent Vanguard -> Icecrown
  [4502] = 67, -- Mimir's Workshop -> The Storm Peaks
  [4503] = 210, -- Ironwall Dam -> Icecrown
  [4504] = 210, -- Valley of Echoes -> Icecrown
  [4505] = 210, -- The Breach -> Icecrown
  [4506] = 210, -- Scourgeholme -> Icecrown
  [4507] = 210, -- The Broken Front -> Icecrown
  [4508] = 210, -- Mord'rethar: The Death Gate -> Icecrown
  [4509] = 210, -- The Bombardment -> Icecrown
  [4510] = 210, -- Aldur'thar: The Desolation Gate -> Icecrown
  [4511] = 210, -- The Skybreaker -> Icecrown
  [4512] = 210, -- Orgrim's Hammer -> Icecrown
  [4513] = 210, -- Ymirheim -> Icecrown
  [4514] = 210, -- Saronite Mines -> Icecrown
  [4515] = 210, -- The Conflagration -> Icecrown
  [4516] = 210, -- Ironwall Rampart -> Icecrown
  [4517] = 210, -- Weeping Quarry -> Icecrown
  [4518] = 210, -- Corp'rethar: The Horror Gate -> Icecrown
  [4519] = 210, -- The Court of Bones -> Icecrown
  [4520] = 210, -- Malykriss: The Vile Hold -> Icecrown
  [4521] = 210, -- Cathedral of Darkness -> Icecrown
  [4522] = 4812, -- Icecrown Citadel -> Icecrown Citadel
  [4523] = 210, -- Icecrown Glacier -> Icecrown
  [4524] = 210, -- Valhalas -> Icecrown
  [4525] = 210, -- The Underhalls -> Icecrown
  [4526] = 210, -- Njorndar Village -> Icecrown
  [4527] = 210, -- Balargarde Fortress -> Icecrown
  [4528] = 210, -- Kul'galar Keep -> Icecrown
  [4529] = 210, -- The Crimson Cathedral -> Icecrown
  [4530] = 210, -- Sanctum of Reanimation -> Icecrown
  [4531] = 210, -- The Fleshwerks -> Icecrown
  [4532] = 495, -- Vengeance Landing Inn -> Howling Fjord
  [4533] = 210, -- Sindragosa's Fall -> Icecrown
  [4534] = 495, -- Wildervar Mine -> Howling Fjord
  [4535] = 67, -- The Pit of the Fang -> The Storm Peaks
  [4536] = 67, -- Frosthowl Cavern -> The Storm Peaks
  [4537] = 210, -- The Valley of Lost Hope -> Icecrown
  [4538] = 4197, -- The Sunken Ring -> Wintergrasp
  [4539] = 4197, -- The Broken Temple -> Wintergrasp
  [4540] = 210, -- The Valley of Fallen Heroes -> Icecrown
  [4541] = 210, -- Vanguard Infirmary -> Icecrown
  [4542] = 67, -- Hall of the Shaper -> The Storm Peaks
  [4543] = 67, -- Temple of Wisdom -> The Storm Peaks
  [4544] = 139, -- Death's Breach -> Eastern Plaguelands
  [4545] = 139, -- Abandoned Mine -> Eastern Plaguelands
  [4546] = 139, -- Ruins of the Scarlet Enclave -> Eastern Plaguelands
  [4547] = 67, -- Halls of Stone -> The Storm Peaks
  [4548] = 4272, -- Halls of Lightning -> Halls of Lightning
  [4549] = 2817, -- The Great Tree -> Crystalsong Forest
  [4550] = 2817, -- The Mirror of Twilight -> Crystalsong Forest
  [4551] = 2817, -- The Twilight Rivulet -> Crystalsong Forest
  [4552] = 2817, -- The Decrepit Flow -> Crystalsong Forest
  [4553] = 2817, -- Forlorn Woods -> Crystalsong Forest
  [4554] = 2817, -- Ruins of Shandaral -> Crystalsong Forest
  [4555] = 2817, -- The Azure Front -> Crystalsong Forest
  [4556] = 2817, -- Violet Stand -> Crystalsong Forest
  [4557] = 2817, -- The Unbound Thicket -> Crystalsong Forest
  [4558] = 2817, -- Sunreaver's Command -> Crystalsong Forest
  [4559] = 2817, -- Windrunner's Overlook -> Crystalsong Forest
  [4560] = 4395, -- The Underbelly -> Dalaran
  [4564] = 4395, -- Krasus' Landing -> Dalaran
  [4567] = 4415, -- The Violet Hold -> The Violet Hold
  [4568] = 4395, -- The Eventide -> Dalaran
  [4569] = 4395, -- Sewer Exit Pipe -> Dalaran
  [4570] = 4395, -- Circle of Wills -> Dalaran
  [4571] = 3277, -- Silverwing Flag Room -> Warsong Gulch
  [4572] = 3277, -- Warsong Flag Room -> Warsong Gulch
  [4575] = 4197, -- Wintergrasp Fortress -> Wintergrasp
  [4576] = 4197, -- Central Bridge -> Wintergrasp
  [4577] = 4197, -- Eastern Bridge -> Wintergrasp
  [4578] = 4197, -- Western Bridge -> Wintergrasp
  [4579] = 66, -- Dubra'Jin -> Zul'Drak
  [4580] = 210, -- Crusaders' Pinnacle -> Icecrown
  [4581] = 4197, -- Flamewatch Tower -> Wintergrasp
  [4582] = 4197, -- Winter's Edge Tower -> Wintergrasp
  [4583] = 4197, -- Shadowsight Tower -> Wintergrasp
  [4584] = 4197, -- The Cauldron of Flames -> Wintergrasp
  [4585] = 4197, -- Glacial Falls -> Wintergrasp
  [4586] = 4197, -- Windy Bluffs -> Wintergrasp
  [4587] = 4197, -- The Forest of Shadows -> Wintergrasp
  [4588] = 210, -- Blackwatch -> Icecrown
  [4589] = 4197, -- The Chilled Quagmire -> Wintergrasp
  [4590] = 4197, -- The Steppe of Life -> Wintergrasp
  [4591] = 210, -- Silent Vigil -> Icecrown
  [4592] = 67, -- Gimorak's Den -> The Storm Peaks
  [4593] = 210, -- The Pit of Fiends -> Icecrown
  [4594] = 210, -- Battlescar Spire -> Icecrown
  [4595] = 210, -- Hall of Horrors -> Icecrown
  [4596] = 210, -- The Circle of Suffering -> Icecrown
  [4597] = 210, -- Rise of Suffering -> Icecrown
  [4598] = 4395, -- Krasus' Landing -> Dalaran
  [4599] = 4395, -- Sewer Exit Pipe -> Dalaran
  [4601] = 4395, -- Dalaran Island -> Dalaran
  [4604] = 4384, -- Gate of the Red Sun -> Strand of the Ancients
  [4605] = 4384, -- Gate of the Blue Sapphire -> Strand of the Ancients
  [4606] = 4384, -- Gate of the Green Emerald -> Strand of the Ancients
  [4607] = 4384, -- Gate of the Purple Amethyst -> Strand of the Ancients
  [4608] = 4384, -- Gate of the Yellow Moon -> Strand of the Ancients
  [4609] = 4384, -- Courtyard of the Ancients -> Strand of the Ancients
  [4610] = 4384, -- Landing Beach -> Strand of the Ancients
  [4611] = 4197, -- Westspark Workshop -> Wintergrasp
  [4612] = 4197, -- Eastspark Workshop -> Wintergrasp
  [4613] = 4395, -- Dalaran City -> Dalaran
  [4614] = 4395, -- The Violet Citadel Spire -> Dalaran
  [4615] = 210, -- Naz'anak: The Forgotten Depths -> Icecrown
  [4616] = 4395, -- Sunreaver's Sanctuary -> Dalaran
  [4617] = 1497, -- Elevator -> Undercity
  [4618] = 4395, -- Antonidas Memorial -> Dalaran
  [4619] = 4395, -- The Violet Citadel -> Dalaran
  [4620] = 4395, -- Magus Commerce Exchange -> Dalaran
  [4621] = 67, -- UNUSED -> The Storm Peaks
  [4622] = 210, -- First Legion Forward Camp -> Icecrown
  [4623] = 4494, -- Hall of the Conquered Kings -> Ahn'kahet: The Old Kingdom
  [4624] = 4494, -- Befouled Terrace -> Ahn'kahet: The Old Kingdom
  [4625] = 4494, -- The Desecrated Altar -> Ahn'kahet: The Old Kingdom
  [4626] = 4494, -- Shimmering Bog -> Ahn'kahet: The Old Kingdom
  [4627] = 4494, -- Fallen Temple of Ahn'kahet -> Ahn'kahet: The Old Kingdom
  [4628] = 1583, -- Halls of Binding -> Blackrock Spire
  [4629] = 67, -- Winter's Heart -> The Storm Peaks
  [4631] = 67, -- The Broodmother's Nest -> The Storm Peaks
  [4632] = 4395, -- Dalaran Floating Rocks -> Dalaran
  [4633] = 4196, -- Raptor Pens -> Drak'Tharon Keep
  [4635] = 4196, -- Drak'Tharon Keep -> Drak'Tharon Keep
  [4636] = 4298, -- The Noxious Pass -> Plaguelands: The Scarlet Enclave
  [4637] = 4395, -- Vargoth's Retreat -> Dalaran
  [4638] = 4395, -- Violet Citadel Balcony -> Dalaran
  [4639] = 3537, -- Band of Variance -> Borean Tundra
  [4640] = 3537, -- Band of Acceleration -> Borean Tundra
  [4641] = 3537, -- Band of Transmutation -> Borean Tundra
  [4642] = 3537, -- Band of Alignment -> Borean Tundra
  [4646] = 394, -- Ashwood Lake -> Grizzly Hills
  [4650] = 4273, -- Iron Concourse -> Ulduar
  [4652] = 4273, -- Formation Grounds -> Ulduar
  [4653] = 4273, -- Razorscale's Aerie -> Ulduar
  [4654] = 4273, -- The Colossal Forge -> Ulduar
  [4655] = 4273, -- The Scrapyard -> Ulduar
  [4656] = 4273, -- The Conservatory of Life -> Ulduar
  [4657] = 4273, -- The Archivum -> Ulduar
  [4658] = 210, -- Argent Tournament Grounds -> Icecrown
  [4659] = 4273, -- The Descent of Madness -> Ulduar (fake ID for Ulduar)
  [4660] = 4273, -- The Spark of Imagination -> Ulduar (fake ID for Ulduar)
  [4661] = 4273, -- The Inner Sanctum of Ulduar -> Ulduar (fake ID for Ulduar)
  [4665] = 4273, -- Expedition Base Camp -> Ulduar
  [4666] = 210, -- Sunreaver Pavilion -> Icecrown
  [4667] = 210, -- Silver Covenant Pavilion -> Icecrown
  [4668] = 40, -- The Cooper Residence -> Westfall
  [4669] = 210, -- The Ring of Champions -> Icecrown
  [4670] = 210, -- The Aspirants' Ring -> Icecrown
  [4671] = 210, -- The Argent Valiants' Ring -> Icecrown
  [4672] = 210, -- The Alliance Valiants' Ring -> Icecrown
  [4673] = 210, -- The Horde Valiants' Ring -> Icecrown
  [4674] = 210, -- Argent Pavilion -> Icecrown
  [4676] = 210, -- Sunreaver Pavilion -> Icecrown
  [4677] = 210, -- Silver Covenant Pavilion -> Icecrown
  [4679] = 1537, -- The Forlorn Cavern -> Ironforge
  [4688] = 151, -- claytonio test area -> Designer Island
  [4692] = 210, -- Quel'Delar's Rest -> Icecrown
  [4739] = 4395, -- Runeweaver Square -> Dalaran
  [4740] = 4395, -- The Silver Enclave -> Dalaran
  [4741] = 4710, -- Isle of Conquest No Man's Land -> Isle of Conquest
  [4743] = 210, -- Deathspeaker's Watch -> Icecrown
  [4747] = 4710, -- Workshop -> Isle of Conquest
  [4748] = 4710, -- Quarry -> Isle of Conquest
  [4749] = 4710, -- Docks -> Isle of Conquest
  [4750] = 4710, -- Hangar -> Isle of Conquest
  [4751] = 4710, -- Refinery -> Isle of Conquest
  [4752] = 4710, -- Horde Keep -> Isle of Conquest
  [4753] = 4710, -- Alliance Keep -> Isle of Conquest
  [4760] = 4742, -- The Sea Reaver's Run -> Hrothgar's Landing
  [4769] = 4742, -- Hrothgar's Landing -> Hrothgar's Landing
  [4801] = 4228, -- The Oculus - Band of Variance (fake ID for The Oculus)
  [4802] = 4228, -- The Oculus - Band of Acceleration (fake ID for The Oculus)
  [4803] = 4228, -- The Oculus - Band of Transmutation (fake ID for The Oculus)
  [4804] = 4228, -- The Oculus - Band of Alignment (fake ID for The Oculus)
  [4805] = 4265, -- The Nexus - dungeon map (fake ID for The Nexus)
  [4806] = 4277, -- Azjol-Nerub - Hadronox's Lair (fake ID for Azjol-Nerub)
  [4807] = 4277, -- Azjol-Nerub - The Gilded Gate (fake ID for Azjol-Nerub)
  [4808] = 4494, -- Ahn'kahet: The Old Kingdom - dungeon map (fake ID for Ahn'kahet: The Old Kingdom)
  [4810] = 4264, -- Halls of Stone - dungeon map (fake ID for Halls of Stone)
  [4811] = 4100, -- The Culling of Stratholme - Village (fake ID for The Culling of Stratholme)
  [4814] = 4100, -- The Culling of Stratholme - City (fake ID for The Culling of Stratholme)
  [4816] = 1196, -- Utgarde Pinnacle - Lower Level (fake ID for Utgarde Pinnacle)
  [4817] = 1196, -- Utgarde Pinnacle - Upper Level (fake ID for Utgarde Pinnacle)
  [4818] = 206, -- Utgarde Keep - Lower Level (fake ID for Utgarde Keep)
  [4819] = 206, -- Utgarde Keep - Middle Level (fake ID for Utgarde Keep)
  [4821] = 206, -- Utgarde Keep - Upper Level (fake ID for Utgarde Keep)
  [4822] = 4196, -- Drak'Tharon Keep - Lower Level (fake ID for Drak'Tharon Keep)
  [4823] = 4196, -- Drak'Tharon Keep - Upper Level (fake ID for Drak'Tharon Keep)
  [4824] = 4416, -- Gundrak - Upper Level (fake ID for Gundrak)
  [4825] = 4416, -- Gundrak - Lower Level (fake ID for Gundrak)
  [4830] = 4812, -- Upper Spire -> Icecrown Citadel (fake ID for ICC)
  [4859] = 4896, -- The Frozen Throne -> The Frozen Throne
  [4862] = 210, -- The Frozen Halls -> Icecrown
  [4889] = 4893, -- The Frost Queen's Lair -> The Frost Queen's Lair
  [4890] = 4812, -- Putricide's Laboratory of Alchemical Horrors and Fun -> Icecrown Citadel
  [4891] = 4897, -- The Sanctum of Blood -> The Sanctum of Blood
  [4892] = 4895, -- The Crimson Hall -> The Crimson Hall
  [4898] = 4896, -- Frostmourne -> The Frozen Throne
  [4904] = 4813, -- The Dark Approach -> Pit of Saron
  [4905] = 4813, -- Scourgelord's Command -> Pit of Saron
  [4906] = 4820, -- The Shadow Throne -> Halls of Reflection
  [4908] = 4820, -- The Hidden Passage -> Halls of Reflection
  [4910] = 4812, -- Frostmourne -> Icecrown Citadel
  [14141] = 210, -- Icecrown -> Icecrown
  [14289] = 14288, -- Westspark Workshop -> Wintergrasp
  [14290] = 14288, -- The Steppe of Life -> Wintergrasp
  [14291] = 14288, -- Eastspark Workshop -> Wintergrasp
  [14292] = 14288, -- The Chilled Quagmire -> Wintergrasp
  [14293] = 14288, -- The Forest of Shadows -> Wintergrasp
  [14294] = 14288, -- Glacial Falls -> Wintergrasp
  [14295] = 14288, -- The Cauldron of Flames -> Wintergrasp
  [14296] = 14288, -- Winter's Edge Tower -> Wintergrasp
  [14297] = 14288, -- Flamewatch Tower -> Wintergrasp
  [14298] = 14288, -- Western Bridge -> Wintergrasp
  [14299] = 14288, -- Central Bridge -> Wintergrasp
  [14300] = 14288, -- Wintergrasp Fortress -> Wintergrasp
  [14301] = 14288, -- The Sunken Ring -> Wintergrasp
  [14302] = 14288, -- Eastern Bridge -> Wintergrasp
  [14303] = 14288, -- The Broken Temple -> Wintergrasp
  [14304] = 14288, -- Shadowsight Tower -> Wintergrasp
  [14305] = 14286, -- The Lifeblood Pillar -> Sholazar Basin
  [14306] = 14286, -- The Lost Lands -> Sholazar Basin
  [14307] = 14286, -- The Skyreach Pillar -> Sholazar Basin
  [14308] = 14286, -- Hardknuckle Clearing -> Sholazar Basin
  [14309] = 14286, -- Sapphire Hive -> Sholazar Basin
  [14310] = 14286, -- Wintergrasp River -> Sholazar Basin
  [14311] = 14286, -- Frenzyheart River -> Sholazar Basin
  [14312] = 14286, -- The Sundered Shard -> Sholazar Basin
  [14313] = 14286, -- Frenzyheart Hill -> Sholazar Basin
  [14314] = 14286, -- Rainspeaker Rapids -> Sholazar Basin
  [14315] = 14286, -- Lakeside Landing -> Sholazar Basin
  [14316] = 14286, -- River's Heart -> Sholazar Basin
  [14317] = 14286, -- Rainspeaker Canopy -> Sholazar Basin
  [14318] = 14286, -- The Blight Line -> Sholazar Basin
  [14319] = 14286, -- Wildgrowth Mangal -> Sholazar Basin
  [14320] = 14286, -- Mosswalker Village -> Sholazar Basin
  [14321] = 14284, -- Temple City of En'kilah -> Borean Tundra
  [14322] = 14284, -- The Borean Wall -> Borean Tundra
  [14323] = 14284, -- North Point Station -> Borean Tundra
  [14324] = 14284, -- Spire of Pain -> Borean Tundra
  [14325] = 14284, -- Spire of Decay -> Borean Tundra
  [14326] = 14284, -- Spire of Blood -> Borean Tundra
  [14327] = 14284, -- The Dens of Dying -> Borean Tundra
  [14328] = 14284, -- Festering Pools -> Borean Tundra
  [14329] = 14284, -- Talramas -> Borean Tundra
  [14330] = 14284, -- Steam Springs -> Borean Tundra
  [14331] = 14284, -- The Flood Plains -> Borean Tundra
  [14332] = 14284, -- The Geyser Fields -> Borean Tundra
  [14333] = 14284, -- Fizzcrank Pumping Station -> Borean Tundra
  [14334] = 14285, -- Icecrown Citadel -> Icecrown
  [14335] = 14285, -- The Court of Bones -> Icecrown
  [14336] = 14287, -- Icemist Village -> Dragonblight
  [14337] = 14287, -- Westwind Refugee Camp -> Dragonblight
  [14338] = 14287, -- Obsidian Dragonshrine -> Dragonblight
  [14339] = 14287, -- Agmar's Hammer -> Dragonblight
  [14340] = 14287, -- Coldwind Pass -> Dragonblight
  [14341] = 14287, -- Angrathar the Wrathgate -> Dragonblight
}
ZoneDB.private.subZoneToParentZone[3545] = 3483 -- Hellfire Citadel -> Hellfire Peninsula
ZoneDB.private.subZoneToParentZone[3563] = 3483 -- Hellfire Citadel -> Hellfire Peninsula

-- Different source of zoneIds
-- These are not in use anymore but are quite helpful when fixing the database
-- https://www.ownedcore.com/forums/world-of-warcraft/world-of-warcraft-emulator-servers/60411-zone-ids.html
---@enum ZoneIDs
ZoneDB.private.zoneIDs = {
    DUN_MOROGH = 1,
    BADLANDS = 3,
    BLASTED_LANDS = 4,
    SWAMP_OF_SORROWS = 8,
    DUSKWOOD = 10,
    WETLANDS = 11,
    ELWYNN_FOREST = 12,
    DUROTAR = 14,
    DUSTWALLOW_MARSH = 15,
    AZSHARA = 16,
    THE_BARRENS = 17,
    WESTERN_PLAGUELANDS = 28,
    STRANGLETHORN_VALE = 33,
    ALTERAC_MOUNTAINS = 36,
    LOCH_MODAN = 38,
    WESTFALL = 40,
    DEADWIND_PASS = 41,
    REDRIDGE_MOUNTAINS = 44,
    ARATHI_HIGHLANDS = 45,
    BURNING_STEPPES = 46,
    THE_HINTERLANDS = 47,
    SEARING_GORGE = 51,
    TIRISFAL_GLADES = 85,
    SILVERPINE_FOREST = 130,
    EASTERN_PLAGUELANDS = 139,
    TELDRASSIL = 141,
    DARKSHORE = 148,
    SHADOWFANG_KEEP = 209,
    MULGORE = 215,
    HILLSBRAD_FOOTHILLS = 267,
    ASHENVALE = 331,
    FERALAS = 357,
    FELWOOD = 361,
    THOUSAND_NEEDLES = 400,
    DESOLACE = 405,
    STONETALON_MOUNTAINS = 406,
    TANARIS = 440,
    UN_GORO_CRATER = 490,
    RAZORFEN_KRAUL = 491,
    MOONGLADE = 493,
    WINTERSPRING = 618,
    THE_STOCKADE = 717,
    WAILING_CAVERNS = 718,
    BLACKFATHOM_DEEPS = 719,
    GNOMEREGAN = 721,
    RAZORFEN_DOWNS = 722,
    SCARLET_MONASTERY = 796,
    ZUL_FARRAK = 1176,
    ULDAMAN = 1337,
    SILITHUS = 1377,
    THE_TEMPLE_OF_ATAL_HAKKAR = 1477,
    UNDERCITY = 1497,
    STORMWIND_CITY = 1519,
    IRONFORGE = 1537,
    THE_DEADMINES = 1581,
    LOWER_BLACKROCK_SPIRE = 1583,
    BLACKROCK_DEPTHS = 1585,
    ORGRIMMAR = 1637,
    THUNDER_BLUFF = 1638,
    DARNASSUS = 1657,
    ZUL_GURUB = 1977,
    STRATHOLME = 2017,
    SCHOLOMANCE = 2057,
    MARAUDON = 2100,
    ONYXIAS_LAIR = 2159,
    DEEPRUN_TRAM = 2257,
    SOUTH_SEAS = 2317,
    THE_BLACK_MORASS = 2366,
    OLD_HILLSBRAD_FOOTHILLS = 2367,
    RAGEFIRE_CHASM = 2437,
    DIRE_MAUL = 2557,
    ALTERAC_VALLEY = 2597,
    BLACKWING_LAIR = 2677,
    MOLTEN_CORE = 2717,
    HALL_OF_LEGENDS = 2917,
    CHAMPIONS_HALL = 2918,
    WARSONG_GULCH = 3277,
    ARATHI_BASIN = 3358,
    AHN_QIRAJ = 3428,
    RUINS_OF_AHN_QIRAJ = 3429,
    NAXXRAMAS = 3456,
    EVERSONG_WOODS = 3430,
    GHOSTLANDS = 3433,
    HELLFIRE_PENINSULA = 3483,
    SILVERMOON_CITY = 3487,
    NAGRAND = 3518,
    TEROKKAR_FOREST = 3519,
    SHADOWMOON_VALLEY = 3520,
    ZANGARMARSH = 3521,
    BLADES_EDGE_MOUNTAINS = 3522,
    NETHERSTORM = 3523,
    AZUREMYST_ISLE = 3524,
    BLOODMYST_ISLE = 3525,
    THE_EXODAR = 3557,
    HELLFIRE_RAMPARTS = 3562,
    HYJAL_SUMMIT = 3606,
    SHATTRATH_CITY = 3703,
    THE_BLOOD_FURNACE = 3713,
    THE_SHATTERED_HALLS = 3714,
    THE_STEAMVAULT = 3715,
    THE_UNDERBOG = 3716,
    THE_SLAVE_PENS = 3717,
    THE_BOTANICA = 3847,
    THE_ARCATRAZ = 3848,
    THE_MECHANAR = 3849,
    SHADOW_LABYRINTH = 3789,
    AUCHENAI_CRYPTS = 3790,
    SETHEKK_HALLS = 3791,
    MANA_TOMBS = 3792,
    TEMPEST_KEEP = 3845,
    ZUL_AMAN = 3805,
    BLACK_TEMPLE = 3959,
    SUNWELL_PLATEAU = 4075,
    ISLE_OF_QUEL_DANAS = 4080,
    MAGISTERS_TERRACE = 4131,
    UPPER_BLACKROCK_SPIRE = 7307,
    DRAGONBLIGHT = 65,
    ZUL_DRAK = 66,
    STORM_PEAKS = 67,
    ICECROWN = 210,
    GRIZZLY_HILLS = 394,
    HOWLING_FJORD = 495,
    CRYSTALSONG_FOREST = 2817,
    BOREAN_TUNDRA = 3537,
    SHOLAZAR_BASIN = 3711,
    WINTERGRASP = 4197,
    THE_NEXUS = 4265,
    ULDUAR = 4273,
    DALARAN = 4395,
    THE_UNDERBELLY = 4560,
    VIOLET_HOLD = 4415,
    UTGARDE_KEEP = 206,
    HALLS_OF_STONE = 4264,
    HALLS_OF_LIGHTNING = 4272,
    PLAGUELANDS_THE_SCARLET_ENCLAVE = 4298,
    THE_ARCHIVUM = 4657,
    TRIAL_OF_THE_CRUSADER = 4722,
    TRIAL_OF_THE_CHAMPION = 4723,
    HROTHGARS_LANDING = 4742,
    ICECROWN_CITADEL = 4812,
    -- Fake IDS for ICC
    ICECROWN_CITADEL_UPPER_SPIRE = 4830, -- UiMapID 190
    -- Fake IDs for Ulduar
    THE_DESCENT_OF_MADNESS = 4659,
    THE_SPARK_OF_IMAGINATION = 4660,
    THE_INNER_SANCTUM_OF_ULDUAR = 4661,
    -- Fake IDs for Hall of Lightning
    THE_TERRESTRIAL_WATCHTOWER = 4274,
    -- Fake IDs for Azjol-Nerub
    THE_BROOD_PIT = 4301,
    HADRONOXS_LAIR = 4806,
    THE_GILDED_GATE = 4807,
    -- Fake IDs for The Oculus
    BAND_OF_VARIANCE = 4801,
    BAND_OF_ACCELERATION = 4802,
    BAND_OF_TRANSMUTATION = 4803,
    BAND_OF_ALIGNMENT = 4804,
    -- Fake IDs for The Nexus
    THE_NEXUS_MAP = 4805,
    -- Fake IDs for Ahn'Kahet: The Old Kingdom
    AHNKAHET_MAP = 4808,
    -- Fake IDs for Halls of Stone
    HALLS_OF_STONE_MAP = 4810,
    -- Fake IDs for The Culling of Stratholme
    THE_CULLING_OF_STRATHOLME_VILLAGE = 4811,
    THE_CULLING_OF_STRATHOLME_CITY = 4814,
    -- Fake IDs for Utgarde Pinnacle
    UTGARDE_PINNACLE_LOWER_LEVEL = 4816,
    UTGARDE_PINNACLE_UPPER_LEVEL = 4817,
    -- Fake IDs for Utgarde Keep
    UTGARDE_KEEP_LOWER_LEVEL = 4818,
    UTGARDE_KEEP_MIDDLE_LEVEL = 4819,
    UTGARDE_KEEP_UPPER_LEVEL = 4821,
    -- Fake IDs for Drak'tharon Keep
    DRAKTHARON_KEEP_LOWER_LEVEL = 4822,
    DRAKTHARON_KEEP_UPPER_LEVEL = 4823,
    -- Fake IDs for Gundrak
    GUNDRAK_UPPER_LEVEL = 4824, --154
    GUNDRAK_LOWER_LEVEL = 4825, --153
}
